export{"rbpl24s"}

rbpl24s = method()
rbpl24s (Ring) := kk -> (
	(x,y,z) := (symbol x, symbol y, symbol z);
	R := kk[x_1..x_3,y_1..y_3,z_1..z_3];
	{ 9.02353177111246e-1*x_1^2+5.06753420513951e-1*y_1^2+1.15409618294195*z_1^2-1.89489327629418,
	5.47653292007868e-1*x_2^2+4.01593017487710e-1*y_2^2+9.14600572619008e-1*z_2^2-1.37399826809834*x_2-3.61818267724270,
	1.26480638249588*x_3^2+2.99953816740793e-1*y_3^2+1.20375754734237*z_3^2+3.46367554661357e-1*x_3-3.03447482544876*y_3-2.08334787313530,
	1.01542688946772*x_1*x_2+6.51626823874782e-1*y_1*y_2+1.48403542964494*z_1*z_2-1.34750418563480*x_2+7.55749719256342e-1,
	1.49129677811074*x_1*x_3+5.44238574067073e-1*y_1*y_3+1.64533483741959*z_1*z_3+1.97899885395127e-1*x_3-1.73377157331563*y_3-2.18250318558661,
	3.63356727880623*x_2*x_3+1.51526503944521*y_2*y_3+4.58092916621510*z_2*z_3-4.97526669091479*x_2+4.55809836346864e-1*x_3-3.99328243934042*y_3-4.37818922423922e-03,
	-1.50354584074328*x_1*y_2*z_3+1.13265335620253*x_1*z_2*y_3+1.31578980431683*y_1*x_2*z_3-1.74297802916645*y_1*z_2*x_3-9.91212703684361e-1*z_1*x_2*y_3+1.74297802916645*z_1*y_2*x_3+3.83650902835643*x_1*y_2+5.63687325659283e-02*x_1*z_2-1.99884215008463*x_1*y_3-3.89852390643551e-02*x_1*z_3-3.35742305082321*y_1*x_2+1.29829675554826*y_1*z_2+3.07590838122797*y_1*x_3-8.97916399527476e-1*y_1*z_3-4.93296589852189e-02*z_1*x_2-1.29829675554826*z_1*y_2+4.51934442633164e-02*z_1*x_3+6.76419697992925e-1*z_1*y_3+2.11450869353619*x_2*y_3+4.12411890141876e-02*x_2*z_3-3.71821525452185*y_2*x_3+1.08541804248264*y_2*z_3-5.46306758971674e-02*z_2*x_3-8.17668710448484e-1*z_2*y_3-9.85984231145044*x_1+2.40411038512531e-1*y_1-3.72647039170064e1*z_1+1.09272995041099*x_2+3.63213093186832e-02*y_2-5.62995295895362*z_2+7.70206259423188*x_3-1.05808258067104e1*y_3+2.12115567191798e1*z_3-6.95578779258571e-1,
	8.46362685065152e-1*x_1*y_2*z_3-6.37583178261945e-1*x_1*z_2*y_3-7.40672722829929e-1*y_1*x_2*z_3+9.81141728306483e-1*y_1*z_2*x_3+5.57964661021749e-1*z_1*x_2*y_3-9.81141728306483e-1*z_1*y_2*x_3+2.15248618665415*x_1*y_2+2.45598327418739*x_1*z_2-1.12145705524443*x_1*y_3-1.69858520360145*x_1*z_3-1.88369340101545*y_1*x_2+1.39179304392241*y_1*z_2+1.72574865667482*y_1*x_3-9.62579466940477e-1*y_1*z_3-2.14929113844038*z_1*x_2-1.39179304392241*z_1*y_2+1.96907643938610*z_1*x_3+7.25131774700529e-1*z_1*y_3+1.18635215524219*x_2*y_3+1.79687684671605*x_2*z_3-2.08611707028712*y_2*x_3+1.16358396092368*y_2*z_3-2.38025621924476*z_2*x_3-8.76552774681028e-1*z_2*y_3+5.27434073456527e-1*x_1-5.22683827930675e-1*y_1+1.04327631315449*z_1+9.43203889658043e-1*x_2-5.43486300980384e-1*y_2+1.08479802518778*z_2+3.44041927386078e-1*x_3+7.67905870025835e-02*y_3+6.49757354494466e-1*z_3+8.38949001135772e-1,
	1.41669698735990*x_2+7.05867245375851e-1 }
 )

beginDocumentation()

doc /// 
    Key
    	rbpl24s
	(rbpl24s,Ring)
    Headline
    	parallel robot with 24 real solutions, after variable scaling
    Usage
	rbpl24s(kk)
    Inputs
	kk:Ring
		the coefficient ring
    Outputs
	:List
		of polynomials in the system
    Description
    	Text
	    This system was solved in May 2020, using @TO solveSystem@ in Macaulay2 v1.15
	     with an Intel(R) Core(TM) i5-5250U CPU at 1.60GHz.
	   
	    There were 40 solutions found in 3.740 seconds (with a Bezout bound of 576). 
	    
	    Reference: generated by Fabrice Rouillier, as a deformation of a system found in Innocenti.
	    
	    See also: http://homepages.math.uic.edu/~jan/Demo/rbpl24s.html.
	Example
	    rbpl24s(RR_53)
    ///