/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File MacroEditor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef MacroEditor_H
#define MacroEditor_H

#ifndef BaseTextEditor_H
#include "BaseTextEditor.h"
#endif

#ifndef Task_H
#include "Task.h"
#endif


class MacroEditor : public BaseTextEditor {
public:

// -- Exceptions
	// None

// -- Contructors

	MacroEditor(const IconClass&,const string&);

// -- Destructor

	virtual ~MacroEditor(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void run();
	void trace();
	void stop();
	void beautify();

	void print();
	void check();
	void external();

	void output(Widget);
	void line(const string&);
	void progress(const string&);

// -- Overridden methods

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	MacroEditor(const MacroEditor&);
	MacroEditor& operator=(const MacroEditor&);

// -- Members

	Widget     output_;
	TaskH       task_;
	IconObjectH temp_;

// -- Methods

	void start(const char *, bool);

// -- Overridden methods

	virtual void merge(IconObject*);
	virtual void replace(IconObject*);
	virtual void reset();

	virtual void modifiedCB(Widget,XtPointer);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const MacroEditor& p)
	//	{ p.print(s); return s; }

};

inline void destroy(MacroEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(MacroEditor);
//#endif

#endif
