/* moonshot-server.c generated by valac 0.24.0, the Vala compiler
 * generated from moonshot-server.vala, do not modify */

/*
 * Copyright (c) 2011-2014, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_MOONSHOT_SERVER (moonshot_server_get_type ())
#define MOONSHOT_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_SERVER, MoonshotServer))
#define MOONSHOT_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_SERVER, MoonshotServerClass))
#define IS_MOONSHOT_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_SERVER))
#define IS_MOONSHOT_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_SERVER))
#define MOONSHOT_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_SERVER, MoonshotServerClass))

typedef struct _MoonshotServer MoonshotServer;
typedef struct _MoonshotServerClass MoonshotServerClass;
typedef struct _MoonshotServerPrivate MoonshotServerPrivate;

#define TYPE_IDENTITY_MANAGER_APP (identity_manager_app_get_type ())
#define IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp))
#define IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))
#define IS_IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_APP))
#define IS_IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_APP))
#define IDENTITY_MANAGER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))

typedef struct _IdentityManagerApp IdentityManagerApp;
typedef struct _IdentityManagerAppClass IdentityManagerAppClass;
#define _identity_manager_app_unref0(var) ((var == NULL) ? NULL : (var = (identity_manager_app_unref (var), NULL)))
typedef struct _IdentityManagerAppPrivate IdentityManagerAppPrivate;

#define TYPE_IDENTITY_MANAGER_MODEL (identity_manager_model_get_type ())
#define IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel))
#define IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))
#define IS_IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_MODEL))
#define IS_IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_MODEL))
#define IDENTITY_MANAGER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))

typedef struct _IdentityManagerModel IdentityManagerModel;
typedef struct _IdentityManagerModelClass IdentityManagerModelClass;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define TYPE_IDENTITY_MANAGER_VIEW (identity_manager_view_get_type ())
#define IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView))
#define IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))
#define IS_IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_VIEW))
#define IS_IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_VIEW))
#define IDENTITY_MANAGER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))

typedef struct _IdentityManagerView IdentityManagerView;
typedef struct _IdentityManagerViewClass IdentityManagerViewClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;

#define TYPE_IDENTITY_REQUEST (identity_request_get_type ())
#define IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_REQUEST, IdentityRequest))
#define IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_REQUEST, IdentityRequestClass))
#define IS_IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_REQUEST))
#define IS_IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_REQUEST))
#define IDENTITY_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_REQUEST, IdentityRequestClass))

typedef struct _IdentityRequest IdentityRequest;
typedef struct _IdentityRequestClass IdentityRequestClass;
typedef struct _IdentityRequestPrivate IdentityRequestPrivate;

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;
typedef struct _MoonshotServerGetIdentityData MoonshotServerGetIdentityData;
typedef struct _Block3Data Block3Data;
typedef struct _MoonshotServerGetDefaultIdentityData MoonshotServerGetDefaultIdentityData;

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

#define WEB_PROVISIONING_TYPE_PARSER (web_provisioning_parser_get_type ())
#define WEB_PROVISIONING_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParser))
#define WEB_PROVISIONING_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParserClass))
#define WEB_PROVISIONING_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WEB_PROVISIONING_TYPE_PARSER))
#define WEB_PROVISIONING_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WEB_PROVISIONING_TYPE_PARSER))
#define WEB_PROVISIONING_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParserClass))

typedef struct _WebProvisioningParser WebProvisioningParser;
typedef struct _WebProvisioningParserClass WebProvisioningParserClass;
#define _web_provisioning_parser_unref0(var) ((var == NULL) ? NULL : (var = (web_provisioning_parser_unref (var), NULL)))

struct _MoonshotServer {
	GObject parent_instance;
	MoonshotServerPrivate * priv;
};

struct _MoonshotServerClass {
	GObjectClass parent_class;
};

struct _MoonshotServerPrivate {
	IdentityManagerApp* parent_app;
};

struct _IdentityManagerApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IdentityManagerAppPrivate * priv;
	IdentityManagerModel* model;
	IdCard* default_id_card;
	gboolean explicitly_launched;
	IdentityManagerView* view;
};

struct _IdentityManagerAppClass {
	GTypeClass parent_class;
	void (*finalize) (IdentityManagerApp *self);
};

struct _Block2Data {
	int _ref_count_;
	MoonshotServer* self;
	gpointer _async_data_;
};

typedef void (*ReturnIdentityCallback) (IdentityRequest* request, void* user_data);
struct _IdentityRequest {
	GObject parent_instance;
	IdentityRequestPrivate * priv;
	IdCard* id_card;
	gboolean complete;
	gboolean select_default;
	gchar* nai;
	gchar* password;
	gchar* service;
	GSList* candidates;
};

struct _IdentityRequestClass {
	GObjectClass parent_class;
};

struct _MoonshotServerGetIdentityData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MoonshotServer* self;
	gchar* nai;
	gchar* password;
	gchar* service;
	gchar* nai_out;
	gchar* password_out;
	gchar* server_certificate_hash;
	gchar* ca_certificate;
	gchar* subject_name_constraint;
	gchar* subject_alt_name_constraint;
	gboolean result;
	Block2Data* _data2_;
	IdentityRequest* request;
	IdentityManagerApp* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	IdentityRequest* _tmp4_;
	IdentityRequest* _tmp5_;
	IdentityRequest* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	IdCard* id_card;
	IdentityRequest* _tmp13_;
	IdCard* _tmp14_;
	IdCard* _tmp15_;
	gboolean _tmp16_;
	IdCard* _tmp17_;
	IdCard* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	IdCard* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gboolean _tmp25_;
	IdentityRequest* _tmp26_;
	const gchar* _tmp27_;
	IdentityRequest* _tmp28_;
	const gchar* _tmp29_;
	IdentityRequest* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	IdCard* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	IdCard* _tmp37_;
	TrustAnchor* _tmp38_;
	TrustAnchor* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	IdCard* _tmp43_;
	TrustAnchor* _tmp44_;
	TrustAnchor* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	IdCard* _tmp49_;
	TrustAnchor* _tmp50_;
	TrustAnchor* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	IdCard* _tmp55_;
	TrustAnchor* _tmp56_;
	TrustAnchor* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	const gchar* _tmp69_;
	gchar* _tmp70_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
};

struct _Block3Data {
	int _ref_count_;
	MoonshotServer* self;
	gpointer _async_data_;
};

struct _MoonshotServerGetDefaultIdentityData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MoonshotServer* self;
	gchar* nai_out;
	gchar* password_out;
	gchar* server_certificate_hash;
	gchar* ca_certificate;
	gchar* subject_name_constraint;
	gchar* subject_alt_name_constraint;
	gboolean result;
	Block3Data* _data3_;
	IdentityRequest* request;
	IdentityManagerApp* _tmp0_;
	IdentityRequest* _tmp1_;
	IdentityRequest* _tmp2_;
	IdentityRequest* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	IdentityRequest* _tmp10_;
	IdCard* _tmp11_;
	IdentityRequest* _tmp12_;
	IdCard* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	IdentityRequest* _tmp17_;
	IdCard* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	IdentityRequest* _tmp22_;
	IdCard* _tmp23_;
	TrustAnchor* _tmp24_;
	TrustAnchor* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	IdentityRequest* _tmp29_;
	IdCard* _tmp30_;
	TrustAnchor* _tmp31_;
	TrustAnchor* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	IdentityRequest* _tmp36_;
	IdCard* _tmp37_;
	TrustAnchor* _tmp38_;
	TrustAnchor* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	IdentityRequest* _tmp43_;
	IdCard* _tmp44_;
	TrustAnchor* _tmp45_;
	TrustAnchor* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};


static gpointer moonshot_server_parent_class = NULL;
extern IdCard** web_provisioning_cards;
extern gint web_provisioning_cards_length1;

GType moonshot_server_get_type (void) G_GNUC_CONST;
guint moonshot_server_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
gpointer identity_manager_app_ref (gpointer instance);
void identity_manager_app_unref (gpointer instance);
GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_identity_manager_app (GValue* value, gpointer v_object);
void value_take_identity_manager_app (GValue* value, gpointer v_object);
gpointer value_get_identity_manager_app (const GValue* value);
GType identity_manager_app_get_type (void) G_GNUC_CONST;
#define MOONSHOT_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MOONSHOT_SERVER, MoonshotServerPrivate))
enum  {
	MOONSHOT_SERVER_DUMMY_PROPERTY
};
MoonshotServer* moonshot_server_new (IdentityManagerApp* app);
MoonshotServer* moonshot_server_construct (GType object_type, IdentityManagerApp* app);
gboolean moonshot_server_show_ui (MoonshotServer* self);
GType identity_manager_model_get_type (void) G_GNUC_CONST;
GType id_card_get_type (void) G_GNUC_CONST;
GType identity_manager_view_get_type (void) G_GNUC_CONST;
void identity_manager_app_show (IdentityManagerApp* self);
static void moonshot_server_get_identity_data_free (gpointer _data);
void moonshot_server_get_identity (MoonshotServer* self, const gchar* nai, const gchar* password, const gchar* service, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean moonshot_server_get_identity_finish (MoonshotServer* self, GAsyncResult* _res_, gchar** nai_out, gchar** password_out, gchar** server_certificate_hash, gchar** ca_certificate, gchar** subject_name_constraint, gchar** subject_alt_name_constraint);
static gboolean moonshot_server_get_identity_co (MoonshotServerGetIdentityData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
GType identity_request_get_type (void) G_GNUC_CONST;
IdentityRequest* identity_request_new (IdentityManagerApp* app, const gchar* nai, const gchar* password, const gchar* service);
IdentityRequest* identity_request_construct (GType object_type, IdentityManagerApp* app, const gchar* nai, const gchar* password, const gchar* service);
void identity_request_set_callback (IdentityRequest* self, ReturnIdentityCallback cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static void __lambda7_ (Block2Data* _data2_, IdentityRequest* IdentityRequest);
static void ___lambda7__return_identity_callback (IdentityRequest* request, gpointer self);
gboolean identity_request_execute (IdentityRequest* self);
const gchar* id_card_get_display_name (IdCard* self);
#define ID_CARD_NO_IDENTITY "No Identity"
const gchar* id_card_get_nai (IdCard* self);
const gchar* id_card_get_password (IdCard* self);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
const gchar* trust_anchor_get_subject (TrustAnchor* self);
const gchar* trust_anchor_get_subject_alt (TrustAnchor* self);
static void moonshot_server_get_default_identity_data_free (gpointer _data);
void moonshot_server_get_default_identity (MoonshotServer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean moonshot_server_get_default_identity_finish (MoonshotServer* self, GAsyncResult* _res_, gchar** nai_out, gchar** password_out, gchar** server_certificate_hash, gchar** ca_certificate, gchar** subject_name_constraint, gchar** subject_alt_name_constraint);
static gboolean moonshot_server_get_default_identity_co (MoonshotServerGetDefaultIdentityData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
IdentityRequest* identity_request_new_default (IdentityManagerApp* app);
IdentityRequest* identity_request_construct_default (GType object_type, IdentityManagerApp* app);
static void __lambda8_ (Block3Data* _data3_, IdentityRequest* IdentityRequest);
static void ___lambda8__return_identity_callback (IdentityRequest* request, gpointer self);
gboolean moonshot_server_install_id_card (MoonshotServer* self, const gchar* display_name, const gchar* user_name, const gchar* password, const gchar* realm, gchar** rules_patterns, int rules_patterns_length1, gchar** rules_always_confirm, int rules_always_confirm_length1, gchar** services, int services_length1, const gchar* ca_cert, const gchar* subject, const gchar* subject_alt, const gchar* server_cert, gint force_flat_file_store);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_password (IdCard* self, const gchar* value);
void id_card_set_store_password (IdCard* self, gboolean value);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_set_services (IdCard* self, gchar** value, int value_length1);
void trust_anchor_set_ca_cert (TrustAnchor* self, const gchar* value);
void trust_anchor_set_subject (TrustAnchor* self, const gchar* value);
void trust_anchor_set_subject_alt (TrustAnchor* self, const gchar* value);
void trust_anchor_set_server_cert (TrustAnchor* self, const gchar* value);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
void id_card_set_rules (IdCard* self, Rule* value, int value_length1);
static void _vala_Rule_array_free (Rule* array, gint array_length);
gboolean identity_manager_app_add_identity (IdentityManagerApp* self, IdCard* id, gboolean force_flat_file_store);
gint moonshot_server_install_from_file (MoonshotServer* self, const gchar* file_name);
gpointer web_provisioning_parser_ref (gpointer instance);
void web_provisioning_parser_unref (gpointer instance);
GParamSpec* web_provisioning_param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void web_provisioning_value_set_parser (GValue* value, gpointer v_object);
void web_provisioning_value_take_parser (GValue* value, gpointer v_object);
gpointer web_provisioning_value_get_parser (const GValue* value);
GType web_provisioning_parser_get_type (void) G_GNUC_CONST;
WebProvisioningParser* web_provisioning_parser_new (const gchar* path);
WebProvisioningParser* web_provisioning_parser_construct (GType object_type, const gchar* path);
void web_provisioning_parser_parse (WebProvisioningParser* self);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
const gchar* id_card_get_username (IdCard* self);
const gchar* id_card_get_issuer (IdCard* self);
gchar** id_card_get_services (IdCard* self, int* result_length1);
static void moonshot_server_finalize (GObject* obj);
static void _dbus_moonshot_server_show_ui (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_moonshot_server_get_identity (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_moonshot_server_get_identity_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_moonshot_server_get_default_identity (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_moonshot_server_get_default_identity_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_moonshot_server_install_id_card (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_moonshot_server_install_from_file (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void moonshot_server_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* moonshot_server_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean moonshot_server_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _moonshot_server_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _moonshot_server_dbus_arg_info_show_ui_result = {-1, "result", "b"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_show_ui_in[] = {NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_show_ui_out[] = {&_moonshot_server_dbus_arg_info_show_ui_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_show_ui = {-1, "ShowUi", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_show_ui_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_show_ui_out)};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_nai = {-1, "nai", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_password = {-1, "password", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_service = {-1, "service", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_nai_out = {-1, "nai_out", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_password_out = {-1, "password_out", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_server_certificate_hash = {-1, "server_certificate_hash", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_ca_certificate = {-1, "ca_certificate", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_subject_name_constraint = {-1, "subject_name_constraint", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_subject_alt_name_constraint = {-1, "subject_alt_name_constraint", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_result = {-1, "result", "b"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_get_identity_in[] = {&_moonshot_server_dbus_arg_info_get_identity_nai, &_moonshot_server_dbus_arg_info_get_identity_password, &_moonshot_server_dbus_arg_info_get_identity_service, NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_get_identity_out[] = {&_moonshot_server_dbus_arg_info_get_identity_nai_out, &_moonshot_server_dbus_arg_info_get_identity_password_out, &_moonshot_server_dbus_arg_info_get_identity_server_certificate_hash, &_moonshot_server_dbus_arg_info_get_identity_ca_certificate, &_moonshot_server_dbus_arg_info_get_identity_subject_name_constraint, &_moonshot_server_dbus_arg_info_get_identity_subject_alt_name_constraint, &_moonshot_server_dbus_arg_info_get_identity_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_get_identity = {-1, "GetIdentity", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_get_identity_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_get_identity_out)};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_nai_out = {-1, "nai_out", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_password_out = {-1, "password_out", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_server_certificate_hash = {-1, "server_certificate_hash", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_ca_certificate = {-1, "ca_certificate", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_subject_name_constraint = {-1, "subject_name_constraint", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_subject_alt_name_constraint = {-1, "subject_alt_name_constraint", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_result = {-1, "result", "b"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_get_default_identity_in[] = {NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_get_default_identity_out[] = {&_moonshot_server_dbus_arg_info_get_default_identity_nai_out, &_moonshot_server_dbus_arg_info_get_default_identity_password_out, &_moonshot_server_dbus_arg_info_get_default_identity_server_certificate_hash, &_moonshot_server_dbus_arg_info_get_default_identity_ca_certificate, &_moonshot_server_dbus_arg_info_get_default_identity_subject_name_constraint, &_moonshot_server_dbus_arg_info_get_default_identity_subject_alt_name_constraint, &_moonshot_server_dbus_arg_info_get_default_identity_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_get_default_identity = {-1, "GetDefaultIdentity", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_get_default_identity_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_get_default_identity_out)};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_display_name = {-1, "display_name", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_user_name = {-1, "user_name", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_password = {-1, "password", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_realm = {-1, "realm", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_rules_patterns = {-1, "rules_patterns", "as"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_rules_always_confirm = {-1, "rules_always_confirm", "as"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_services = {-1, "services", "as"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_ca_cert = {-1, "ca_cert", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_subject = {-1, "subject", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_subject_alt = {-1, "subject_alt", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_server_cert = {-1, "server_cert", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_force_flat_file_store = {-1, "force_flat_file_store", "i"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_result = {-1, "result", "b"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_install_id_card_in[] = {&_moonshot_server_dbus_arg_info_install_id_card_display_name, &_moonshot_server_dbus_arg_info_install_id_card_user_name, &_moonshot_server_dbus_arg_info_install_id_card_password, &_moonshot_server_dbus_arg_info_install_id_card_realm, &_moonshot_server_dbus_arg_info_install_id_card_rules_patterns, &_moonshot_server_dbus_arg_info_install_id_card_rules_always_confirm, &_moonshot_server_dbus_arg_info_install_id_card_services, &_moonshot_server_dbus_arg_info_install_id_card_ca_cert, &_moonshot_server_dbus_arg_info_install_id_card_subject, &_moonshot_server_dbus_arg_info_install_id_card_subject_alt, &_moonshot_server_dbus_arg_info_install_id_card_server_cert, &_moonshot_server_dbus_arg_info_install_id_card_force_flat_file_store, NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_install_id_card_out[] = {&_moonshot_server_dbus_arg_info_install_id_card_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_install_id_card = {-1, "InstallIdCard", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_install_id_card_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_install_id_card_out)};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_from_file_file_name = {-1, "file_name", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_from_file_result = {-1, "result", "i"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_install_from_file_in[] = {&_moonshot_server_dbus_arg_info_install_from_file_file_name, NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_install_from_file_out[] = {&_moonshot_server_dbus_arg_info_install_from_file_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_install_from_file = {-1, "InstallFromFile", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_install_from_file_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_install_from_file_out)};
static const GDBusMethodInfo * const _moonshot_server_dbus_method_info[] = {&_moonshot_server_dbus_method_info_show_ui, &_moonshot_server_dbus_method_info_get_identity, &_moonshot_server_dbus_method_info_get_default_identity, &_moonshot_server_dbus_method_info_install_id_card, &_moonshot_server_dbus_method_info_install_from_file, NULL};
static const GDBusSignalInfo * const _moonshot_server_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _moonshot_server_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _moonshot_server_dbus_interface_info = {-1, "org.janet.Moonshot", (GDBusMethodInfo **) (&_moonshot_server_dbus_method_info), (GDBusSignalInfo **) (&_moonshot_server_dbus_signal_info), (GDBusPropertyInfo **) (&_moonshot_server_dbus_property_info)};
static const GDBusInterfaceVTable _moonshot_server_dbus_interface_vtable = {moonshot_server_dbus_interface_method_call, moonshot_server_dbus_interface_get_property, moonshot_server_dbus_interface_set_property};

static gpointer _identity_manager_app_ref0 (gpointer self) {
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return self ? identity_manager_app_ref (self) : NULL;
#line 540 "moonshot-server.c"
}


MoonshotServer* moonshot_server_construct (GType object_type, IdentityManagerApp* app) {
	MoonshotServer * self = NULL;
	IdentityManagerApp* _tmp0_ = NULL;
	IdentityManagerApp* _tmp1_ = NULL;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_return_val_if_fail (app != NULL, NULL);
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	self = (MoonshotServer*) g_object_new (object_type, NULL);
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp0_ = app;
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp1_ = _identity_manager_app_ref0 (_tmp0_);
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_identity_manager_app_unref0 (self->priv->parent_app);
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	self->priv->parent_app = _tmp1_;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return self;
#line 562 "moonshot-server.c"
}


MoonshotServer* moonshot_server_new (IdentityManagerApp* app) {
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return moonshot_server_construct (TYPE_MOONSHOT_SERVER, app);
#line 569 "moonshot-server.c"
}


gboolean moonshot_server_show_ui (MoonshotServer* self) {
	gboolean result = FALSE;
	IdentityManagerApp* _tmp0_ = NULL;
	IdentityManagerView* _tmp1_ = NULL;
	IdentityManagerApp* _tmp2_ = NULL;
	IdentityManagerApp* _tmp3_ = NULL;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp0_ = self->priv->parent_app;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp1_ = _tmp0_->view;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_tmp1_ == NULL) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		result = FALSE;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		return result;
#line 591 "moonshot-server.c"
	}
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp2_ = self->priv->parent_app;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	identity_manager_app_show (_tmp2_);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp3_ = self->priv->parent_app;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp3_->explicitly_launched = TRUE;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	result = TRUE;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return result;
#line 605 "moonshot-server.c"
}


static void moonshot_server_get_identity_data_free (gpointer _data) {
	MoonshotServerGetIdentityData* _data_;
	_data_ = _data;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->nai);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->password);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->service);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_slice_free (MoonshotServerGetIdentityData, _data_);
#line 622 "moonshot-server.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return self ? g_object_ref (self) : NULL;
#line 629 "moonshot-server.c"
}


void moonshot_server_get_identity (MoonshotServer* self, const gchar* nai, const gchar* password, const gchar* service, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MoonshotServerGetIdentityData* _data_;
	MoonshotServer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_ = g_slice_new0 (MoonshotServerGetIdentityData);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, moonshot_server_get_identity);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, moonshot_server_get_identity_data_free);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->self = _tmp0_;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp1_ = nai;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->nai);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->nai = _tmp2_;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp3_ = password;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->password);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->password = _tmp4_;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp5_ = service;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->service);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->service = _tmp6_;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	moonshot_server_get_identity_co (_data_);
#line 678 "moonshot-server.c"
}


gboolean moonshot_server_get_identity_finish (MoonshotServer* self, GAsyncResult* _res_, gchar** nai_out, gchar** password_out, gchar** server_certificate_hash, gchar** ca_certificate, gchar** subject_name_constraint, gchar** subject_alt_name_constraint) {
	gboolean result;
	MoonshotServerGetIdentityData* _data_;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (nai_out) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*nai_out = _data_->nai_out;
#line 691 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->nai_out);
#line 695 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->nai_out = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (password_out) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*password_out = _data_->password_out;
#line 703 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->password_out);
#line 707 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->password_out = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (server_certificate_hash) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*server_certificate_hash = _data_->server_certificate_hash;
#line 715 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->server_certificate_hash);
#line 719 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->server_certificate_hash = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (ca_certificate) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*ca_certificate = _data_->ca_certificate;
#line 727 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->ca_certificate);
#line 731 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->ca_certificate = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (subject_name_constraint) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*subject_name_constraint = _data_->subject_name_constraint;
#line 739 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->subject_name_constraint);
#line 743 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->subject_name_constraint = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (subject_alt_name_constraint) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*subject_alt_name_constraint = _data_->subject_alt_name_constraint;
#line 751 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->subject_alt_name_constraint);
#line 755 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->subject_alt_name_constraint = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	result = _data_->result;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return result;
#line 763 "moonshot-server.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return _data2_;
#line 772 "moonshot-server.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 781 "moonshot-server.c"
		MoonshotServer* self;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		self = _data2_->self;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_object_unref0 (self);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_slice_free (Block2Data, _data2_);
#line 789 "moonshot-server.c"
	}
}


static void __lambda7_ (Block2Data* _data2_, IdentityRequest* IdentityRequest) {
	MoonshotServer* self;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	self = _data2_->self;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_return_if_fail (IdentityRequest != NULL);
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	moonshot_server_get_identity_co (_data2_->_async_data_);
#line 802 "moonshot-server.c"
}


static void ___lambda7__return_identity_callback (IdentityRequest* request, gpointer self) {
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	__lambda7_ (self, request);
#line 809 "moonshot-server.c"
}


static gboolean moonshot_server_get_identity_co (MoonshotServerGetIdentityData* _data_) {
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	switch (_data_->_state_) {
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		case 0:
#line 818 "moonshot-server.c"
		goto _state_0;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		case 1:
#line 822 "moonshot-server.c"
		goto _state_1;
		default:
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_assert_not_reached ();
#line 827 "moonshot-server.c"
	}
	_state_0:
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp0_ = NULL;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp0_ = _data_->self->priv->parent_app;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp1_ = NULL;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp1_ = _data_->nai;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp2_ = NULL;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp2_ = _data_->password;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp3_ = NULL;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp3_ = _data_->service;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp4_ = NULL;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp4_ = identity_request_new (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->request = _data_->_tmp4_;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp5_ = NULL;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp5_ = _data_->request;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	identity_request_set_callback (_data_->_tmp5_, ___lambda7__return_identity_callback, block2_data_ref (_data_->_data2_), block2_data_unref);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp6_ = NULL;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp6_ = _data_->request;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	identity_request_execute (_data_->_tmp6_);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_state_ = 1;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return FALSE;
#line 876 "moonshot-server.c"
	_state_1:
	;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp7_ = NULL;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp7_ = g_strdup ("");
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->nai_out);
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->nai_out = _data_->_tmp7_;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp8_ = NULL;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp8_ = g_strdup ("");
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->password_out);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->password_out = _data_->_tmp8_;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp9_ = NULL;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp9_ = g_strdup ("");
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->server_certificate_hash);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->server_certificate_hash = _data_->_tmp9_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp10_ = NULL;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp10_ = g_strdup ("");
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->ca_certificate);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->ca_certificate = _data_->_tmp10_;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp11_ = NULL;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp11_ = g_strdup ("");
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->subject_name_constraint);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->subject_name_constraint = _data_->_tmp11_;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp12_ = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp12_ = g_strdup ("");
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->subject_alt_name_constraint);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->subject_alt_name_constraint = _data_->_tmp12_;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp13_ = NULL;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp13_ = _data_->request;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp14_ = NULL;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp14_ = _data_->_tmp13_->id_card;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp15_ = NULL;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->id_card = _data_->_tmp15_;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp17_ = NULL;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp17_ = _data_->id_card;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_data_->_tmp17_ != NULL) {
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp18_ = NULL;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp18_ = _data_->id_card;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp19_ = NULL;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp19_ = id_card_get_display_name (_data_->_tmp18_);
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp20_ = NULL;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp20_ = _data_->_tmp19_;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp16_ = g_strcmp0 (_data_->_tmp20_, ID_CARD_NO_IDENTITY) != 0;
#line 961 "moonshot-server.c"
	} else {
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp16_ = FALSE;
#line 965 "moonshot-server.c"
	}
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_data_->_tmp16_) {
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp21_ = NULL;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp21_ = _data_->id_card;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp22_ = NULL;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp22_ = id_card_get_nai (_data_->_tmp21_);
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp23_ = NULL;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp23_ = _data_->_tmp22_;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp24_ = NULL;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp24_ = g_strdup (_data_->_tmp23_);
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->nai_out);
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->nai_out = _data_->_tmp24_;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp26_ = NULL;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp26_ = _data_->request;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp27_ = NULL;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp27_ = _data_->_tmp26_->password;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp27_ != NULL) {
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp28_ = NULL;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp28_ = _data_->request;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp29_ = NULL;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp29_ = _data_->_tmp28_->password;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp25_ = g_strcmp0 (_data_->_tmp29_, "") != 0;
#line 1009 "moonshot-server.c"
		} else {
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp25_ = FALSE;
#line 1013 "moonshot-server.c"
		}
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp25_) {
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp30_ = NULL;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp30_ = _data_->request;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp31_ = NULL;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp31_ = _data_->_tmp30_->password;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp32_ = NULL;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp32_ = g_strdup (_data_->_tmp31_);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->password_out);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->password_out = _data_->_tmp32_;
#line 1033 "moonshot-server.c"
		} else {
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp33_ = NULL;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp33_ = _data_->id_card;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp34_ = NULL;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp34_ = id_card_get_password (_data_->_tmp33_);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp35_ = NULL;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp35_ = _data_->_tmp34_;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp36_ = NULL;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp36_ = g_strdup (_data_->_tmp35_);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->password_out);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->password_out = _data_->_tmp36_;
#line 1055 "moonshot-server.c"
		}
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp37_ = NULL;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp37_ = _data_->id_card;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp38_ = NULL;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp38_ = id_card_get_trust_anchor (_data_->_tmp37_);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp39_ = NULL;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp39_ = _data_->_tmp38_;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp40_ = NULL;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp40_ = trust_anchor_get_server_cert (_data_->_tmp39_);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp41_ = NULL;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp41_ = _data_->_tmp40_;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp42_ = NULL;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp42_ = g_strdup (_data_->_tmp41_);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->server_certificate_hash);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->server_certificate_hash = _data_->_tmp42_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp43_ = NULL;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp43_ = _data_->id_card;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp44_ = NULL;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp44_ = id_card_get_trust_anchor (_data_->_tmp43_);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp45_ = NULL;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp45_ = _data_->_tmp44_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp46_ = NULL;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp46_ = trust_anchor_get_ca_cert (_data_->_tmp45_);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp47_ = NULL;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp47_ = _data_->_tmp46_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp48_ = NULL;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp48_ = g_strdup (_data_->_tmp47_);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->ca_certificate);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->ca_certificate = _data_->_tmp48_;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp49_ = NULL;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp49_ = _data_->id_card;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp50_ = NULL;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp50_ = id_card_get_trust_anchor (_data_->_tmp49_);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp51_ = NULL;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp51_ = _data_->_tmp50_;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp52_ = NULL;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp52_ = trust_anchor_get_subject (_data_->_tmp51_);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp53_ = NULL;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp53_ = _data_->_tmp52_;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp54_ = NULL;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp54_ = g_strdup (_data_->_tmp53_);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->subject_name_constraint);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->subject_name_constraint = _data_->_tmp54_;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp55_ = NULL;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp55_ = _data_->id_card;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp56_ = NULL;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp56_ = id_card_get_trust_anchor (_data_->_tmp55_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp57_ = NULL;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp57_ = _data_->_tmp56_;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp58_ = NULL;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp58_ = trust_anchor_get_subject_alt (_data_->_tmp57_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp59_ = NULL;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp59_ = _data_->_tmp58_;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp60_ = NULL;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp60_ = g_strdup (_data_->_tmp59_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->subject_alt_name_constraint);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->subject_alt_name_constraint = _data_->_tmp60_;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp61_ = NULL;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp61_ = _data_->nai_out;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp61_ == NULL) {
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp62_ = NULL;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp62_ = g_strdup ("");
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->nai_out);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->nai_out = _data_->_tmp62_;
#line 1183 "moonshot-server.c"
		}
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp63_ = NULL;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp63_ = _data_->password_out;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp63_ == NULL) {
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp64_ = NULL;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp64_ = g_strdup ("");
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->password_out);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->password_out = _data_->_tmp64_;
#line 1199 "moonshot-server.c"
		}
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp65_ = NULL;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp65_ = _data_->server_certificate_hash;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp65_ == NULL) {
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp66_ = NULL;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp66_ = g_strdup ("");
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->server_certificate_hash);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->server_certificate_hash = _data_->_tmp66_;
#line 1215 "moonshot-server.c"
		}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp67_ = NULL;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp67_ = _data_->ca_certificate;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp67_ == NULL) {
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp68_ = NULL;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp68_ = g_strdup ("");
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->ca_certificate);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->ca_certificate = _data_->_tmp68_;
#line 1231 "moonshot-server.c"
		}
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp69_ = NULL;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp69_ = _data_->subject_name_constraint;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp69_ == NULL) {
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp70_ = NULL;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp70_ = g_strdup ("");
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->subject_name_constraint);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->subject_name_constraint = _data_->_tmp70_;
#line 1247 "moonshot-server.c"
		}
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp71_ = NULL;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp71_ = _data_->subject_alt_name_constraint;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp71_ == NULL) {
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp72_ = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp72_ = g_strdup ("");
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->subject_alt_name_constraint);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->subject_alt_name_constraint = _data_->_tmp72_;
#line 1263 "moonshot-server.c"
		}
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->result = TRUE;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_object_unref0 (_data_->id_card);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_object_unref0 (_data_->request);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		block2_data_unref (_data_->_data2_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_data2_ = NULL;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_state_ == 0) {
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1279 "moonshot-server.c"
		} else {
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1283 "moonshot-server.c"
		}
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_object_unref (_data_->_async_result);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		return FALSE;
#line 1289 "moonshot-server.c"
	}
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->result = FALSE;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_object_unref0 (_data_->id_card);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_object_unref0 (_data_->request);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	block2_data_unref (_data_->_data2_);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data2_ = NULL;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_data_->_state_ == 0) {
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1305 "moonshot-server.c"
	} else {
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1309 "moonshot-server.c"
	}
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_object_unref (_data_->_async_result);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return FALSE;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_object_unref0 (_data_->id_card);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_object_unref0 (_data_->request);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	block2_data_unref (_data_->_data2_);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data2_ = NULL;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_data_->_state_ == 0) {
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1327 "moonshot-server.c"
	} else {
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1331 "moonshot-server.c"
	}
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_object_unref (_data_->_async_result);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return FALSE;
#line 1337 "moonshot-server.c"
}


static void moonshot_server_get_default_identity_data_free (gpointer _data) {
	MoonshotServerGetDefaultIdentityData* _data_;
	_data_ = _data;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_slice_free (MoonshotServerGetDefaultIdentityData, _data_);
#line 1348 "moonshot-server.c"
}


void moonshot_server_get_default_identity (MoonshotServer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MoonshotServerGetDefaultIdentityData* _data_;
	MoonshotServer* _tmp0_ = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_ = g_slice_new0 (MoonshotServerGetDefaultIdentityData);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, moonshot_server_get_default_identity);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, moonshot_server_get_default_identity_data_free);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->self = _tmp0_;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	moonshot_server_get_default_identity_co (_data_);
#line 1367 "moonshot-server.c"
}


gboolean moonshot_server_get_default_identity_finish (MoonshotServer* self, GAsyncResult* _res_, gchar** nai_out, gchar** password_out, gchar** server_certificate_hash, gchar** ca_certificate, gchar** subject_name_constraint, gchar** subject_alt_name_constraint) {
	gboolean result;
	MoonshotServerGetDefaultIdentityData* _data_;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (nai_out) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*nai_out = _data_->nai_out;
#line 1380 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->nai_out);
#line 1384 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->nai_out = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (password_out) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*password_out = _data_->password_out;
#line 1392 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->password_out);
#line 1396 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->password_out = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (server_certificate_hash) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*server_certificate_hash = _data_->server_certificate_hash;
#line 1404 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->server_certificate_hash);
#line 1408 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->server_certificate_hash = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (ca_certificate) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*ca_certificate = _data_->ca_certificate;
#line 1416 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->ca_certificate);
#line 1420 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->ca_certificate = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (subject_name_constraint) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*subject_name_constraint = _data_->subject_name_constraint;
#line 1428 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->subject_name_constraint);
#line 1432 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->subject_name_constraint = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (subject_alt_name_constraint) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		*subject_alt_name_constraint = _data_->subject_alt_name_constraint;
#line 1440 "moonshot-server.c"
	} else {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->subject_alt_name_constraint);
#line 1444 "moonshot-server.c"
	}
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->subject_alt_name_constraint = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	result = _data_->result;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return result;
#line 1452 "moonshot-server.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return _data3_;
#line 1461 "moonshot-server.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1470 "moonshot-server.c"
		MoonshotServer* self;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		self = _data3_->self;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_object_unref0 (self);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_slice_free (Block3Data, _data3_);
#line 1478 "moonshot-server.c"
	}
}


static void __lambda8_ (Block3Data* _data3_, IdentityRequest* IdentityRequest) {
	MoonshotServer* self;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	self = _data3_->self;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_return_if_fail (IdentityRequest != NULL);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	moonshot_server_get_default_identity_co (_data3_->_async_data_);
#line 1491 "moonshot-server.c"
}


static void ___lambda8__return_identity_callback (IdentityRequest* request, gpointer self) {
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	__lambda8_ (self, request);
#line 1498 "moonshot-server.c"
}


static gboolean moonshot_server_get_default_identity_co (MoonshotServerGetDefaultIdentityData* _data_) {
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	switch (_data_->_state_) {
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		case 0:
#line 1507 "moonshot-server.c"
		goto _state_0;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		case 1:
#line 1511 "moonshot-server.c"
		goto _state_1;
		default:
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_assert_not_reached ();
#line 1516 "moonshot-server.c"
	}
	_state_0:
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data3_ = g_slice_new0 (Block3Data);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data3_->_ref_count_ = 1;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data3_->self = g_object_ref (_data_->self);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data3_->_async_data_ = _data_;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp0_ = NULL;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp0_ = _data_->self->priv->parent_app;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp1_ = NULL;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp1_ = identity_request_new_default (_data_->_tmp0_);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->request = _data_->_tmp1_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp2_ = NULL;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp2_ = _data_->request;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	identity_request_set_callback (_data_->_tmp2_, ___lambda8__return_identity_callback, block3_data_ref (_data_->_data3_), block3_data_unref);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp3_ = NULL;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp3_ = _data_->request;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	identity_request_execute (_data_->_tmp3_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_state_ = 1;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return FALSE;
#line 1553 "moonshot-server.c"
	_state_1:
	;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp4_ = NULL;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp4_ = g_strdup ("");
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->nai_out);
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->nai_out = _data_->_tmp4_;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp5_ = NULL;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp5_ = g_strdup ("");
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->password_out);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->password_out = _data_->_tmp5_;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp6_ = NULL;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp6_ = g_strdup ("");
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->server_certificate_hash);
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->server_certificate_hash = _data_->_tmp6_;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp7_ = NULL;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp7_ = g_strdup ("");
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->ca_certificate);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->ca_certificate = _data_->_tmp7_;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp8_ = NULL;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp8_ = g_strdup ("");
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->subject_name_constraint);
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->subject_name_constraint = _data_->_tmp8_;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp9_ = NULL;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp9_ = g_strdup ("");
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_free0 (_data_->subject_alt_name_constraint);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->subject_alt_name_constraint = _data_->_tmp9_;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp10_ = NULL;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp10_ = _data_->request;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp11_ = NULL;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_tmp11_ = _data_->_tmp10_->id_card;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_data_->_tmp11_ != NULL) {
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp12_ = NULL;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp12_ = _data_->request;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp13_ = NULL;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp13_ = _data_->_tmp12_->id_card;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp14_ = NULL;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp14_ = id_card_get_nai (_data_->_tmp13_);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp15_ = NULL;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp16_ = NULL;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->nai_out);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->nai_out = _data_->_tmp16_;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp17_ = NULL;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp17_ = _data_->request;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp18_ = NULL;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp18_ = _data_->_tmp17_->id_card;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp19_ = NULL;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp19_ = id_card_get_password (_data_->_tmp18_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp20_ = NULL;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp20_ = _data_->_tmp19_;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp21_ = NULL;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp21_ = g_strdup (_data_->_tmp20_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->password_out);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->password_out = _data_->_tmp21_;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp22_ = NULL;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp22_ = _data_->request;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp23_ = NULL;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp23_ = _data_->_tmp22_->id_card;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp24_ = NULL;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp24_ = id_card_get_trust_anchor (_data_->_tmp23_);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp25_ = NULL;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp25_ = _data_->_tmp24_;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp26_ = NULL;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp26_ = trust_anchor_get_server_cert (_data_->_tmp25_);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp27_ = NULL;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp27_ = _data_->_tmp26_;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp28_ = NULL;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp28_ = g_strdup (_data_->_tmp27_);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->server_certificate_hash);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->server_certificate_hash = _data_->_tmp28_;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp29_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp29_ = _data_->request;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp30_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp30_ = _data_->_tmp29_->id_card;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp31_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp31_ = id_card_get_trust_anchor (_data_->_tmp30_);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp32_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp32_ = _data_->_tmp31_;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp33_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp33_ = trust_anchor_get_ca_cert (_data_->_tmp32_);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp34_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp34_ = _data_->_tmp33_;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp35_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp35_ = g_strdup (_data_->_tmp34_);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->ca_certificate);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->ca_certificate = _data_->_tmp35_;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp36_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp36_ = _data_->request;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp37_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp37_ = _data_->_tmp36_->id_card;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp38_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp38_ = id_card_get_trust_anchor (_data_->_tmp37_);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp39_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp39_ = _data_->_tmp38_;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp40_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp40_ = trust_anchor_get_subject (_data_->_tmp39_);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp41_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp41_ = _data_->_tmp40_;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp42_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp42_ = g_strdup (_data_->_tmp41_);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->subject_name_constraint);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->subject_name_constraint = _data_->_tmp42_;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp43_ = NULL;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp43_ = _data_->request;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp44_ = NULL;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp44_ = _data_->_tmp43_->id_card;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp45_ = NULL;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp45_ = id_card_get_trust_anchor (_data_->_tmp44_);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp46_ = NULL;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp46_ = _data_->_tmp45_;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp47_ = NULL;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp47_ = trust_anchor_get_subject_alt (_data_->_tmp46_);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp48_ = NULL;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp48_ = _data_->_tmp47_;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp49_ = NULL;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp49_ = g_strdup (_data_->_tmp48_);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_free0 (_data_->subject_alt_name_constraint);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->subject_alt_name_constraint = _data_->_tmp49_;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp50_ = NULL;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp50_ = _data_->nai_out;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp50_ == NULL) {
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp51_ = NULL;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp51_ = g_strdup ("");
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->nai_out);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->nai_out = _data_->_tmp51_;
#line 1804 "moonshot-server.c"
		}
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp52_ = NULL;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp52_ = _data_->password_out;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp52_ == NULL) {
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp53_ = NULL;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp53_ = g_strdup ("");
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->password_out);
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->password_out = _data_->_tmp53_;
#line 1820 "moonshot-server.c"
		}
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp54_ = NULL;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp54_ = _data_->server_certificate_hash;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp54_ == NULL) {
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp55_ = NULL;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp55_ = g_strdup ("");
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->server_certificate_hash);
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->server_certificate_hash = _data_->_tmp55_;
#line 1836 "moonshot-server.c"
		}
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp56_ = NULL;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp56_ = _data_->ca_certificate;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp56_ == NULL) {
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp57_ = NULL;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp57_ = g_strdup ("");
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->ca_certificate);
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->ca_certificate = _data_->_tmp57_;
#line 1852 "moonshot-server.c"
		}
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp58_ = NULL;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp58_ = _data_->subject_name_constraint;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp58_ == NULL) {
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp59_ = NULL;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp59_ = g_strdup ("");
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->subject_name_constraint);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->subject_name_constraint = _data_->_tmp59_;
#line 1868 "moonshot-server.c"
		}
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp60_ = NULL;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_tmp60_ = _data_->subject_alt_name_constraint;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_tmp60_ == NULL) {
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp61_ = NULL;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->_tmp61_ = g_strdup ("");
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_g_free0 (_data_->subject_alt_name_constraint);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_data_->subject_alt_name_constraint = _data_->_tmp61_;
#line 1884 "moonshot-server.c"
		}
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->result = TRUE;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_g_object_unref0 (_data_->request);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		block3_data_unref (_data_->_data3_);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_data_->_data3_ = NULL;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		if (_data_->_state_ == 0) {
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1898 "moonshot-server.c"
		} else {
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1902 "moonshot-server.c"
		}
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_object_unref (_data_->_async_result);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		return FALSE;
#line 1908 "moonshot-server.c"
	}
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->result = FALSE;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_object_unref0 (_data_->request);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	block3_data_unref (_data_->_data3_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data3_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_data_->_state_ == 0) {
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1922 "moonshot-server.c"
	} else {
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1926 "moonshot-server.c"
	}
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_object_unref (_data_->_async_result);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return FALSE;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_object_unref0 (_data_->request);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	block3_data_unref (_data_->_data3_);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_data_->_data3_ = NULL;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_data_->_state_ == 0) {
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1942 "moonshot-server.c"
	} else {
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1946 "moonshot-server.c"
	}
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_object_unref (_data_->_async_result);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return FALSE;
#line 1952 "moonshot-server.c"
}


static void _vala_Rule_array_free (Rule* array, gint array_length) {
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (array != NULL) {
#line 1959 "moonshot-server.c"
		int i;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			rule_destroy (&array[i]);
#line 1965 "moonshot-server.c"
		}
	}
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_free (array);
#line 1970 "moonshot-server.c"
}


gboolean moonshot_server_install_id_card (MoonshotServer* self, const gchar* display_name, const gchar* user_name, const gchar* password, const gchar* realm, gchar** rules_patterns, int rules_patterns_length1, gchar** rules_always_confirm, int rules_always_confirm_length1, gchar** services, int services_length1, const gchar* ca_cert, const gchar* subject, const gchar* subject_alt, const gchar* server_cert, gint force_flat_file_store) {
	gboolean result = FALSE;
	IdCard* idcard = NULL;
	IdCard* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	IdCard* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	IdCard* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	IdCard* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	IdCard* _tmp15_ = NULL;
	TrustAnchor* _tmp16_ = NULL;
	TrustAnchor* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	IdCard* _tmp19_ = NULL;
	TrustAnchor* _tmp20_ = NULL;
	TrustAnchor* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	IdCard* _tmp23_ = NULL;
	TrustAnchor* _tmp24_ = NULL;
	TrustAnchor* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	IdCard* _tmp27_ = NULL;
	TrustAnchor* _tmp28_ = NULL;
	TrustAnchor* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gchar** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	IdentityManagerApp* _tmp53_ = NULL;
	IdCard* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	gboolean _tmp56_ = FALSE;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_return_val_if_fail (display_name != NULL, FALSE);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_return_val_if_fail (user_name != NULL, FALSE);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp0_ = id_card_new ();
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	idcard = _tmp0_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp1_ = idcard;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp2_ = display_name;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	id_card_set_display_name (_tmp1_, _tmp2_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp3_ = idcard;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp4_ = user_name;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	id_card_set_username (_tmp3_, _tmp4_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp5_ = idcard;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp6_ = password;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	id_card_set_password (_tmp5_, _tmp6_);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp8_ = password;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_tmp8_ != NULL) {
#line 2047 "moonshot-server.c"
		const gchar* _tmp9_ = NULL;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_tmp9_ = password;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_tmp7_ = g_strcmp0 (_tmp9_, "") != 0;
#line 2053 "moonshot-server.c"
	} else {
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_tmp7_ = FALSE;
#line 2057 "moonshot-server.c"
	}
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_tmp7_) {
#line 2061 "moonshot-server.c"
		IdCard* _tmp10_ = NULL;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_tmp10_ = idcard;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		id_card_set_store_password (_tmp10_, TRUE);
#line 2067 "moonshot-server.c"
	}
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp11_ = idcard;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp12_ = realm;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	id_card_set_issuer (_tmp11_, _tmp12_);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp13_ = idcard;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp14_ = services;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp14__length1 = services_length1;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	id_card_set_services (_tmp13_, _tmp14_, _tmp14__length1);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp15_ = idcard;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp16_ = id_card_get_trust_anchor (_tmp15_);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp17_ = _tmp16_;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp18_ = ca_cert;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	trust_anchor_set_ca_cert (_tmp17_, _tmp18_);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp19_ = idcard;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp20_ = id_card_get_trust_anchor (_tmp19_);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp21_ = _tmp20_;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp22_ = subject;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	trust_anchor_set_subject (_tmp21_, _tmp22_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp23_ = idcard;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp24_ = id_card_get_trust_anchor (_tmp23_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp25_ = _tmp24_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp26_ = subject_alt;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	trust_anchor_set_subject_alt (_tmp25_, _tmp26_);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp27_ = idcard;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp28_ = id_card_get_trust_anchor (_tmp27_);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp29_ = _tmp28_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp30_ = server_cert;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	trust_anchor_set_server_cert (_tmp29_, _tmp30_);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp31_ = rules_patterns;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp31__length1 = rules_patterns_length1;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp32_ = rules_always_confirm;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp32__length1 = rules_always_confirm_length1;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	if (_tmp31__length1 == _tmp32__length1) {
#line 2133 "moonshot-server.c"
		Rule* rules = NULL;
		gchar** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		Rule* _tmp34_ = NULL;
		gint rules_length1 = 0;
		gint _rules_size_ = 0;
		IdCard* _tmp51_ = NULL;
		Rule* _tmp52_ = NULL;
		gint _tmp52__length1 = 0;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_tmp33_ = rules_patterns;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_tmp33__length1 = rules_patterns_length1;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_tmp34_ = g_new0 (Rule, _tmp33__length1);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		rules = _tmp34_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		rules_length1 = _tmp33__length1;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_rules_size_ = rules_length1;
#line 2155 "moonshot-server.c"
		{
			gint i = 0;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			i = 0;
#line 2160 "moonshot-server.c"
			{
				gboolean _tmp35_ = FALSE;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp35_ = TRUE;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				while (TRUE) {
#line 2167 "moonshot-server.c"
					gint _tmp37_ = 0;
					Rule* _tmp38_ = NULL;
					gint _tmp38__length1 = 0;
					Rule* _tmp39_ = NULL;
					gint _tmp39__length1 = 0;
					gint _tmp40_ = 0;
					gchar** _tmp41_ = NULL;
					gint _tmp41__length1 = 0;
					gint _tmp42_ = 0;
					const gchar* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					Rule* _tmp45_ = NULL;
					gint _tmp45__length1 = 0;
					gint _tmp46_ = 0;
					gchar** _tmp47_ = NULL;
					gint _tmp47__length1 = 0;
					gint _tmp48_ = 0;
					const gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					if (!_tmp35_) {
#line 2189 "moonshot-server.c"
						gint _tmp36_ = 0;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
						_tmp36_ = i;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
						i = _tmp36_ + 1;
#line 2195 "moonshot-server.c"
					}
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp35_ = FALSE;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp37_ = i;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp38_ = rules;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp38__length1 = rules_length1;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					if (!(_tmp37_ < _tmp38__length1)) {
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
						break;
#line 2209 "moonshot-server.c"
					}
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp39_ = rules;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp39__length1 = rules_length1;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp40_ = i;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp41_ = rules_patterns;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp41__length1 = rules_patterns_length1;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp42_ = i;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp43_ = _tmp41_[_tmp42_];
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp44_ = g_strdup (_tmp43_);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_g_free0 (_tmp39_[_tmp40_].pattern);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp39_[_tmp40_].pattern = _tmp44_;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp45_ = rules;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp45__length1 = rules_length1;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp46_ = i;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp47_ = rules_always_confirm;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp47__length1 = rules_always_confirm_length1;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp48_ = i;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp49_ = _tmp47_[_tmp48_];
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp50_ = g_strdup (_tmp49_);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_g_free0 (_tmp45_[_tmp46_].always_confirm);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp45_[_tmp46_].always_confirm = _tmp50_;
#line 2251 "moonshot-server.c"
				}
			}
		}
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_tmp51_ = idcard;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_tmp52_ = rules;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		_tmp52__length1 = rules_length1;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		id_card_set_rules (_tmp51_, _tmp52_, _tmp52__length1);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 2265 "moonshot-server.c"
	}
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp53_ = self->priv->parent_app;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp54_ = idcard;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp55_ = force_flat_file_store;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp56_ = identity_manager_app_add_identity (_tmp53_, _tmp54_, _tmp55_ != 0);
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	result = _tmp56_;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_g_object_unref0 (idcard);
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return result;
#line 2281 "moonshot-server.c"
}


gint moonshot_server_install_from_file (MoonshotServer* self, const gchar* file_name) {
	gint result = 0;
	WebProvisioningParser* webp = NULL;
	const gchar* _tmp0_ = NULL;
	WebProvisioningParser* _tmp1_ = NULL;
	WebProvisioningParser* _tmp2_ = NULL;
	gboolean _result_ = FALSE;
	gint installed_cards = 0;
	IdCard** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_return_val_if_fail (file_name != NULL, 0);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp0_ = file_name;
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp1_ = web_provisioning_parser_new (_tmp0_);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	webp = _tmp1_;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp2_ = webp;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	web_provisioning_parser_parse (_tmp2_);
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_result_ = FALSE;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	installed_cards = 0;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp3_ = web_provisioning_cards;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_tmp3__length1 = web_provisioning_cards_length1;
#line 2317 "moonshot-server.c"
	{
		IdCard** card_collection = NULL;
		gint card_collection_length1 = 0;
		gint _card_collection_size_ = 0;
		gint card_it = 0;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		card_collection = _tmp3_;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		card_collection_length1 = _tmp3__length1;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
		for (card_it = 0; card_it < _tmp3__length1; card_it = card_it + 1) {
#line 2329 "moonshot-server.c"
			IdCard* _tmp4_ = NULL;
			IdCard* card = NULL;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			_tmp4_ = _g_object_ref0 (card_collection[card_it]);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
			card = _tmp4_;
#line 2336 "moonshot-server.c"
			{
				gchar** rules_patterns = NULL;
				gchar** _tmp5_ = NULL;
				gint rules_patterns_length1 = 0;
				gint _rules_patterns_size_ = 0;
				gchar** rules_always_confirm = NULL;
				gchar** _tmp6_ = NULL;
				gint rules_always_confirm_length1 = 0;
				gint _rules_always_confirm_size_ = 0;
				IdCard* _tmp7_ = NULL;
				Rule* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				Rule* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				IdCard* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				IdCard* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				IdCard* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				IdCard* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gchar** _tmp48_ = NULL;
				gint _tmp48__length1 = 0;
				IdCard* _tmp49_ = NULL;
				gchar** _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				gchar** _tmp51_ = NULL;
				gint _tmp51__length1 = 0;
				IdCard* _tmp52_ = NULL;
				TrustAnchor* _tmp53_ = NULL;
				TrustAnchor* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				IdCard* _tmp57_ = NULL;
				TrustAnchor* _tmp58_ = NULL;
				TrustAnchor* _tmp59_ = NULL;
				const gchar* _tmp60_ = NULL;
				const gchar* _tmp61_ = NULL;
				IdCard* _tmp62_ = NULL;
				TrustAnchor* _tmp63_ = NULL;
				TrustAnchor* _tmp64_ = NULL;
				const gchar* _tmp65_ = NULL;
				const gchar* _tmp66_ = NULL;
				IdCard* _tmp67_ = NULL;
				TrustAnchor* _tmp68_ = NULL;
				TrustAnchor* _tmp69_ = NULL;
				const gchar* _tmp70_ = NULL;
				const gchar* _tmp71_ = NULL;
				gboolean _tmp72_ = FALSE;
				gboolean _tmp73_ = FALSE;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp5_ = g_new0 (gchar*, 0 + 1);
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				rules_patterns = _tmp5_;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				rules_patterns_length1 = 0;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_rules_patterns_size_ = rules_patterns_length1;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp6_ = g_new0 (gchar*, 0 + 1);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				rules_always_confirm = _tmp6_;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				rules_always_confirm_length1 = 0;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_rules_always_confirm_size_ = rules_always_confirm_length1;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp7_ = card;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp8_ = id_card_get_rules (_tmp7_, &_tmp8__length1);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp9_ = _tmp8_;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp9__length1 = _tmp8__length1;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				if (_tmp9__length1 > 0) {
#line 2420 "moonshot-server.c"
					gint i = 0;
					IdCard* _tmp10_ = NULL;
					Rule* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					Rule* _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					gchar** _tmp13_ = NULL;
					IdCard* _tmp14_ = NULL;
					Rule* _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					Rule* _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gchar** _tmp17_ = NULL;
					IdCard* _tmp18_ = NULL;
					Rule* _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					Rule* _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					i = 0;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp10_ = card;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp11_ = id_card_get_rules (_tmp10_, &_tmp11__length1);
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp12_ = _tmp11_;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp12__length1 = _tmp11__length1;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp13_ = g_new0 (gchar*, _tmp12__length1 + 1);
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					rules_patterns = _tmp13_;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					rules_patterns_length1 = _tmp12__length1;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_rules_patterns_size_ = rules_patterns_length1;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp14_ = card;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp15_ = id_card_get_rules (_tmp14_, &_tmp15__length1);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp16_ = _tmp15_;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp16__length1 = _tmp15__length1;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp17_ = g_new0 (gchar*, _tmp16__length1 + 1);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					rules_always_confirm = (_vala_array_free (rules_always_confirm, rules_always_confirm_length1, (GDestroyNotify) g_free), NULL);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					rules_always_confirm = _tmp17_;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					rules_always_confirm_length1 = _tmp16__length1;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_rules_always_confirm_size_ = rules_always_confirm_length1;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp18_ = card;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp19_ = id_card_get_rules (_tmp18_, &_tmp19__length1);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp20_ = _tmp19_;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp20__length1 = _tmp19__length1;
#line 2485 "moonshot-server.c"
					{
						Rule* r_collection = NULL;
						gint r_collection_length1 = 0;
						gint _r_collection_size_ = 0;
						gint r_it = 0;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
						r_collection = _tmp20_;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
						r_collection_length1 = _tmp20__length1;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
						for (r_it = 0; r_it < _tmp20__length1; r_it = r_it + 1) {
#line 2497 "moonshot-server.c"
							Rule _tmp21_ = {0};
							Rule r = {0};
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
							rule_copy (&r_collection[r_it], &_tmp21_);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
							r = _tmp21_;
#line 2504 "moonshot-server.c"
							{
								gchar** _tmp22_ = NULL;
								gint _tmp22__length1 = 0;
								gint _tmp23_ = 0;
								Rule _tmp24_ = {0};
								const gchar* _tmp25_ = NULL;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								gchar** _tmp28_ = NULL;
								gint _tmp28__length1 = 0;
								gint _tmp29_ = 0;
								Rule _tmp30_ = {0};
								const gchar* _tmp31_ = NULL;
								gchar* _tmp32_ = NULL;
								gchar* _tmp33_ = NULL;
								gint _tmp34_ = 0;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp22_ = rules_patterns;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp22__length1 = rules_patterns_length1;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp23_ = i;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp24_ = r;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp25_ = _tmp24_.pattern;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp26_ = g_strdup (_tmp25_);
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_g_free0 (_tmp22_[_tmp23_]);
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp22_[_tmp23_] = _tmp26_;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp27_ = _tmp22_[_tmp23_];
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp28_ = rules_always_confirm;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp28__length1 = rules_always_confirm_length1;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp29_ = i;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp30_ = r;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp31_ = _tmp30_.always_confirm;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp32_ = g_strdup (_tmp31_);
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_g_free0 (_tmp28_[_tmp29_]);
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp28_[_tmp29_] = _tmp32_;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp33_ = _tmp28_[_tmp29_];
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								_tmp34_ = i;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								i = _tmp34_ + 1;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
								rule_destroy (&r);
#line 2563 "moonshot-server.c"
							}
						}
					}
				}
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp35_ = card;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp36_ = id_card_get_display_name (_tmp35_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp37_ = _tmp36_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp38_ = card;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp39_ = id_card_get_username (_tmp38_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp40_ = _tmp39_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp41_ = card;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp42_ = id_card_get_password (_tmp41_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp43_ = _tmp42_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp44_ = card;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp45_ = id_card_get_issuer (_tmp44_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp46_ = _tmp45_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp47_ = rules_patterns;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp47__length1 = rules_patterns_length1;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp48_ = rules_always_confirm;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp48__length1 = rules_always_confirm_length1;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp49_ = card;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp50_ = id_card_get_services (_tmp49_, &_tmp50__length1);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp51_ = _tmp50_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp51__length1 = _tmp50__length1;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp52_ = card;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp53_ = id_card_get_trust_anchor (_tmp52_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp54_ = _tmp53_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp55_ = trust_anchor_get_ca_cert (_tmp54_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp56_ = _tmp55_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp57_ = card;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp58_ = id_card_get_trust_anchor (_tmp57_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp59_ = _tmp58_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp60_ = trust_anchor_get_subject (_tmp59_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp61_ = _tmp60_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp62_ = card;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp63_ = id_card_get_trust_anchor (_tmp62_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp64_ = _tmp63_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp65_ = trust_anchor_get_subject_alt (_tmp64_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp66_ = _tmp65_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp67_ = card;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp68_ = id_card_get_trust_anchor (_tmp67_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp69_ = _tmp68_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp70_ = trust_anchor_get_server_cert (_tmp69_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp71_ = _tmp70_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp72_ = moonshot_server_install_id_card (self, _tmp37_, _tmp40_, _tmp43_, _tmp46_, _tmp47_, _tmp47__length1, _tmp48_, _tmp48__length1, _tmp51_, _tmp51__length1, _tmp56_, _tmp61_, _tmp66_, _tmp71_, 0);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_result_ = _tmp72_;
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_tmp73_ = _result_;
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				if (_tmp73_) {
#line 2656 "moonshot-server.c"
					gint _tmp74_ = 0;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					_tmp74_ = installed_cards;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
					installed_cards = _tmp74_ + 1;
#line 2662 "moonshot-server.c"
				}
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				rules_always_confirm = (_vala_array_free (rules_always_confirm, rules_always_confirm_length1, (GDestroyNotify) g_free), NULL);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
				_g_object_unref0 (card);
#line 2670 "moonshot-server.c"
			}
		}
	}
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	result = installed_cards;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_web_provisioning_parser_unref0 (webp);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	return result;
#line 2680 "moonshot-server.c"
}


static void moonshot_server_class_init (MoonshotServerClass * klass) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	moonshot_server_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	g_type_class_add_private (klass, sizeof (MoonshotServerPrivate));
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	G_OBJECT_CLASS (klass)->finalize = moonshot_server_finalize;
#line 2691 "moonshot-server.c"
}


static void moonshot_server_instance_init (MoonshotServer * self) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	self->priv = MOONSHOT_SERVER_GET_PRIVATE (self);
#line 2698 "moonshot-server.c"
}


static void moonshot_server_finalize (GObject* obj) {
	MoonshotServer * self;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOONSHOT_SERVER, MoonshotServer);
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	_identity_manager_app_unref0 (self->priv->parent_app);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server.vala"
	G_OBJECT_CLASS (moonshot_server_parent_class)->finalize (obj);
#line 2710 "moonshot-server.c"
}


GType moonshot_server_get_type (void) {
	static volatile gsize moonshot_server_type_id__volatile = 0;
	if (g_once_init_enter (&moonshot_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MoonshotServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moonshot_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MoonshotServer), 0, (GInstanceInitFunc) moonshot_server_instance_init, NULL };
		GType moonshot_server_type_id;
		moonshot_server_type_id = g_type_register_static (G_TYPE_OBJECT, "MoonshotServer", &g_define_type_info, 0);
		g_type_set_qdata (moonshot_server_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) moonshot_server_register_object);
		g_once_init_leave (&moonshot_server_type_id__volatile, moonshot_server_type_id);
	}
	return moonshot_server_type_id__volatile;
}


static void _dbus_moonshot_server_show_ui (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = moonshot_server_show_ui (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_moonshot_server_get_identity (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* nai = NULL;
	GVariant* _tmp1_;
	gchar* password = NULL;
	GVariant* _tmp2_;
	gchar* service = NULL;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	nai = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	password = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	service = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	moonshot_server_get_identity (self, nai, password, service, (GAsyncReadyCallback) _dbus_moonshot_server_get_identity_ready, invocation);
	_g_free0 (nai);
	_g_free0 (password);
	_g_free0 (service);
}


static void _dbus_moonshot_server_get_identity_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* nai_out = NULL;
	gchar* password_out = NULL;
	gchar* server_certificate_hash = NULL;
	gchar* ca_certificate = NULL;
	gchar* subject_name_constraint = NULL;
	gchar* subject_alt_name_constraint = NULL;
	gboolean result;
	invocation = _user_data_;
	result = moonshot_server_get_identity_finish ((MoonshotServer*) source_object, _res_, &nai_out, &password_out, &server_certificate_hash, &ca_certificate, &subject_name_constraint, &subject_alt_name_constraint);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (nai_out));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (password_out));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (server_certificate_hash));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (ca_certificate));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (subject_name_constraint));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (subject_alt_name_constraint));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (nai_out);
	_g_free0 (password_out);
	_g_free0 (server_certificate_hash);
	_g_free0 (ca_certificate);
	_g_free0 (subject_name_constraint);
	_g_free0 (subject_alt_name_constraint);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_moonshot_server_get_default_identity (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	moonshot_server_get_default_identity (self, (GAsyncReadyCallback) _dbus_moonshot_server_get_default_identity_ready, invocation);
}


static void _dbus_moonshot_server_get_default_identity_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* nai_out = NULL;
	gchar* password_out = NULL;
	gchar* server_certificate_hash = NULL;
	gchar* ca_certificate = NULL;
	gchar* subject_name_constraint = NULL;
	gchar* subject_alt_name_constraint = NULL;
	gboolean result;
	invocation = _user_data_;
	result = moonshot_server_get_default_identity_finish ((MoonshotServer*) source_object, _res_, &nai_out, &password_out, &server_certificate_hash, &ca_certificate, &subject_name_constraint, &subject_alt_name_constraint);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (nai_out));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (password_out));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (server_certificate_hash));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (ca_certificate));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (subject_name_constraint));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (subject_alt_name_constraint));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (nai_out);
	_g_free0 (password_out);
	_g_free0 (server_certificate_hash);
	_g_free0 (ca_certificate);
	_g_free0 (subject_name_constraint);
	_g_free0 (subject_alt_name_constraint);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_moonshot_server_install_id_card (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* display_name = NULL;
	GVariant* _tmp4_;
	gchar* user_name = NULL;
	GVariant* _tmp5_;
	gchar* password = NULL;
	GVariant* _tmp6_;
	gchar* realm = NULL;
	GVariant* _tmp7_;
	gchar** rules_patterns = NULL;
	int rules_patterns_length1 = 0;
	GVariant* _tmp8_;
	gchar** _tmp9_;
	int _tmp9__length;
	int _tmp9__size;
	int _tmp9__length1;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	gchar** rules_always_confirm = NULL;
	int rules_always_confirm_length1 = 0;
	GVariant* _tmp12_;
	gchar** _tmp13_;
	int _tmp13__length;
	int _tmp13__size;
	int _tmp13__length1;
	GVariantIter _tmp14_;
	GVariant* _tmp15_;
	gchar** services = NULL;
	int services_length1 = 0;
	GVariant* _tmp16_;
	gchar** _tmp17_;
	int _tmp17__length;
	int _tmp17__size;
	int _tmp17__length1;
	GVariantIter _tmp18_;
	GVariant* _tmp19_;
	gchar* ca_cert = NULL;
	GVariant* _tmp20_;
	gchar* subject = NULL;
	GVariant* _tmp21_;
	gchar* subject_alt = NULL;
	GVariant* _tmp22_;
	gchar* server_cert = NULL;
	GVariant* _tmp23_;
	gint force_flat_file_store = 0;
	GVariant* _tmp24_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	display_name = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	user_name = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	password = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	realm = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp9_ = g_new (gchar*, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	g_variant_iter_init (&_tmp10_, _tmp8_);
	for (; (_tmp11_ = g_variant_iter_next_value (&_tmp10_)) != NULL; _tmp9__length1++) {
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (gchar*, _tmp9_, _tmp9__size + 1);
		}
		_tmp9_[_tmp9__length++] = g_variant_dup_string (_tmp11_, NULL);
		g_variant_unref (_tmp11_);
	}
	rules_patterns_length1 = _tmp9__length1;
	_tmp9_[_tmp9__length] = NULL;
	rules_patterns = _tmp9_;
	g_variant_unref (_tmp8_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp13_ = g_new (gchar*, 5);
	_tmp13__length = 0;
	_tmp13__size = 4;
	_tmp13__length1 = 0;
	g_variant_iter_init (&_tmp14_, _tmp12_);
	for (; (_tmp15_ = g_variant_iter_next_value (&_tmp14_)) != NULL; _tmp13__length1++) {
		if (_tmp13__size == _tmp13__length) {
			_tmp13__size = 2 * _tmp13__size;
			_tmp13_ = g_renew (gchar*, _tmp13_, _tmp13__size + 1);
		}
		_tmp13_[_tmp13__length++] = g_variant_dup_string (_tmp15_, NULL);
		g_variant_unref (_tmp15_);
	}
	rules_always_confirm_length1 = _tmp13__length1;
	_tmp13_[_tmp13__length] = NULL;
	rules_always_confirm = _tmp13_;
	g_variant_unref (_tmp12_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp17_ = g_new (gchar*, 5);
	_tmp17__length = 0;
	_tmp17__size = 4;
	_tmp17__length1 = 0;
	g_variant_iter_init (&_tmp18_, _tmp16_);
	for (; (_tmp19_ = g_variant_iter_next_value (&_tmp18_)) != NULL; _tmp17__length1++) {
		if (_tmp17__size == _tmp17__length) {
			_tmp17__size = 2 * _tmp17__size;
			_tmp17_ = g_renew (gchar*, _tmp17_, _tmp17__size + 1);
		}
		_tmp17_[_tmp17__length++] = g_variant_dup_string (_tmp19_, NULL);
		g_variant_unref (_tmp19_);
	}
	services_length1 = _tmp17__length1;
	_tmp17_[_tmp17__length] = NULL;
	services = _tmp17_;
	g_variant_unref (_tmp16_);
	_tmp20_ = g_variant_iter_next_value (&_arguments_iter);
	ca_cert = g_variant_dup_string (_tmp20_, NULL);
	g_variant_unref (_tmp20_);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	subject = g_variant_dup_string (_tmp21_, NULL);
	g_variant_unref (_tmp21_);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	subject_alt = g_variant_dup_string (_tmp22_, NULL);
	g_variant_unref (_tmp22_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	server_cert = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	force_flat_file_store = g_variant_get_int32 (_tmp24_);
	g_variant_unref (_tmp24_);
	result = moonshot_server_install_id_card (self, display_name, user_name, password, realm, rules_patterns, rules_patterns_length1, rules_always_confirm, rules_always_confirm_length1, services, services_length1, ca_cert, subject, subject_alt, server_cert, force_flat_file_store);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (display_name);
	_g_free0 (user_name);
	_g_free0 (password);
	_g_free0 (realm);
	rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
	rules_always_confirm = (_vala_array_free (rules_always_confirm, rules_always_confirm_length1, (GDestroyNotify) g_free), NULL);
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (ca_cert);
	_g_free0 (subject);
	_g_free0 (subject_alt);
	_g_free0 (server_cert);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_moonshot_server_install_from_file (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* file_name = NULL;
	GVariant* _tmp25_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp25_ = g_variant_iter_next_value (&_arguments_iter);
	file_name = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	result = moonshot_server_install_from_file (self, file_name);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (file_name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void moonshot_server_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowUi") == 0) {
		_dbus_moonshot_server_show_ui (object, parameters, invocation);
	} else if (strcmp (method_name, "GetIdentity") == 0) {
		_dbus_moonshot_server_get_identity (object, parameters, invocation);
	} else if (strcmp (method_name, "GetDefaultIdentity") == 0) {
		_dbus_moonshot_server_get_default_identity (object, parameters, invocation);
	} else if (strcmp (method_name, "InstallIdCard") == 0) {
		_dbus_moonshot_server_install_id_card (object, parameters, invocation);
	} else if (strcmp (method_name, "InstallFromFile") == 0) {
		_dbus_moonshot_server_install_from_file (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* moonshot_server_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean moonshot_server_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint moonshot_server_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_moonshot_server_dbus_interface_info), &_moonshot_server_dbus_interface_vtable, data, _moonshot_server_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _moonshot_server_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



