/*
 * Copyright 2017 Palantir Technologies, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Classes } from "@blueprintjs/core";

const NS = Classes.getClassNamespace();

export const TABLE_BODY = `${NS}-table-body`;
export const TABLE_BODY_CELLS = `${NS}-table-body-cells`;
export const TABLE_BODY_SCROLLING_INDICATOR_OVERLAY = `${NS}-table-body-scrolling-indicator-overlay`;
export const TABLE_BODY_IS_SCROLLING_TOP = `${NS}-table-body-is-scrolling-top`;
export const TABLE_BODY_IS_SCROLLING_BOTTOM = `${NS}-table-body-is-scrolling-bottom`;
export const TABLE_BODY_IS_SCROLLING_RIGHT = `${NS}-table-body-is-scrolling-right`;
export const TABLE_BODY_IS_SCROLLING_LEFT = `${NS}-table-body-is-scrolling-left`;
export const TABLE_BODY_SCROLL_CLIENT = `${NS}-table-body-scroll-client`;
export const TABLE_BODY_VIRTUAL_CLIENT = `${NS}-table-body-virtual-client`;
export const TABLE_BOTTOM_CONTAINER = `${NS}-table-bottom-container`;
export const TABLE_CELL = `${NS}-table-cell`;
export const TABLE_CELL_CLIENT = `${NS}-table-cell-client`;
export const TABLE_CELL_GHOST = `${NS}-table-cell-ghost`;
export const TABLE_CELL_INTERACTIVE = `${NS}-table-cell-interactive`;
export const TABLE_CELL_LEDGER_EVEN = `${NS}-table-cell-ledger-even`;
export const TABLE_CELL_LEDGER_ODD = `${NS}-table-cell-ledger-odd`;
export const TABLE_COLUMN_HEADER_TR = `${NS}-table-column-header-tr`;
export const TABLE_COLUMN_HEADERS = `${NS}-table-column-headers`;
export const TABLE_COLUMN_HEADER_CELL = `${NS}-table-column-header-cell`;
export const TABLE_COLUMN_NAME = `${NS}-table-column-name`;
export const TABLE_COLUMN_NAME_TEXT = `${NS}-table-column-name-text`;
export const TABLE_CONTAINER = `${NS}-table-container`;
export const TABLE_DRAGGING = `${NS}-table-dragging`;
export const TABLE_EDITABLE_NAME = `${NS}-table-editable-name`;
export const TABLE_EDITABLE_TEXT = `${NS}-table-editable-text`;
export const TABLE_CELL_TEXT_PLACEHOLDER = `${NS}-table-cell-text-placeholder`;
export const TABLE_FOCUS_REGION = `${NS}-table-focus-region`;
export const TABLE_HAS_INTERACTION_BAR = `${NS}-table-has-interaction-bar`;
export const TABLE_HAS_REORDER_HANDLE = `${NS}-table-has-reorder-handle`;
export const TABLE_HEADER = `${NS}-table-header`;
export const TABLE_HEADER_ACTIVE = `${NS}-table-header-active`;
export const TABLE_HEADER_CONTENT = `${NS}-table-header-content`;
export const TABLE_HEADER_REORDERABLE = `${NS}-table-header-reorderable`;
export const TABLE_HEADER_SELECTED = `${NS}-table-header-selected`;
export const TABLE_HORIZONTAL_CELL_DIVIDER = `${NS}-table-horizontal-cell-divider`;
export const TABLE_HORIZONTAL_GUIDE = `${NS}-table-horizontal-guide`;
export const TABLE_INTERACTION_BAR = `${NS}-table-interaction-bar`;
export const TABLE_LAST_IN_COLUMN = `${NS}-table-last-in-column`;
export const TABLE_LAST_IN_ROW = `${NS}-table-last-in-row`;
export const TABLE_MENU = `${NS}-table-menu`;
export const TABLE_NO_HORIZONTAL_SCROLL = `${NS}-table-no-horizontal-scroll`;
export const TABLE_NO_LAYOUT = `${NS}-table-no-layout`;
export const TABLE_NO_ROWS = `${NS}-table-no-rows`;
export const TABLE_NO_VERTICAL_SCROLL = `${NS}-table-no-vertical-scroll`;
export const TABLE_NO_WRAP_TEXT = `${NS}-table-no-wrap-text`;
export const TABLE_NULL = `${NS}-table-null`;
export const TABLE_OVERLAY = `${NS}-table-overlay`;
export const TABLE_OVERLAY_LAYER = `${NS}-table-overlay-layer`;
export const TABLE_OVERLAY_REORDERING_CURSOR = `${NS}-table-reordering-cursor-overlay`;
export const TABLE_POPOVER_WHITESPACE_NORMAL = `${NS}-table-popover-whitespace-normal`;
export const TABLE_POPOVER_WHITESPACE_PRE = `${NS}-table-popover-whitespace-pre`;
export const TABLE_QUADRANT = `${NS}-table-quadrant`;
export const TABLE_QUADRANT_BODY_CONTAINER = `${NS}-table-quadrant-body-container`;
export const TABLE_QUADRANT_LEFT = `${NS}-table-quadrant-left`;
export const TABLE_QUADRANT_MAIN = `${NS}-table-quadrant-main`;
export const TABLE_QUADRANT_SCROLL_CONTAINER = `${NS}-table-quadrant-scroll-container`;
export const TABLE_QUADRANT_STACK = `${NS}-table-quadrant-stack`;
export const TABLE_QUADRANT_TOP = `${NS}-table-quadrant-top`;
export const TABLE_QUADRANT_TOP_LEFT = `${NS}-table-quadrant-top-left`;
export const TABLE_REGION = `${NS}-table-region`;
export const TABLE_REORDER_HANDLE = `${NS}-table-reorder-handle`;
export const TABLE_REORDER_HANDLE_TARGET = `${NS}-table-reorder-handle-target`;
export const TABLE_REORDERING = `${NS}-table-reordering`;
export const TABLE_RESIZE_GUIDES = `${NS}-table-resize-guides`;
export const TABLE_RESIZE_HANDLE = `${NS}-table-resize-handle`;
export const TABLE_RESIZE_HANDLE_TARGET = `${NS}-table-resize-handle-target`;
export const TABLE_RESIZE_HORIZONTAL = `${NS}-table-resize-horizontal`;
export const TABLE_RESIZE_SENSOR = `${NS}-table-resize-sensor`;
export const TABLE_RESIZE_SENSOR_EXPAND = `${NS}-table-resize-sensor-expand`;
export const TABLE_RESIZE_SENSOR_SHRINK = `${NS}-table-resize-sensor-shrink`;
export const TABLE_RESIZE_VERTICAL = `${NS}-table-resize-vertical`;
export const TABLE_ROUNDED_LAYOUT = `${NS}-table-rounded-layout`;
export const TABLE_ROW_HEADERS = `${NS}-table-row-headers`;
export const TABLE_ROW_HEADERS_CELLS_CONTAINER = `${NS}-table-row-headers-cells-container`;
export const TABLE_ROW_NAME = `${NS}-table-row-name`;
export const TABLE_ROW_NAME_TEXT = `${NS}-table-row-name-text`;
export const TABLE_SELECTION_ENABLED = `${NS}-table-selection-enabled`;
export const TABLE_SELECTION_REGION = `${NS}-table-selection-region`;
export const TABLE_TH_MENU = `${NS}-table-th-menu`;
export const TABLE_TH_MENU_CONTAINER = `${NS}-table-th-menu-container`;
export const TABLE_TH_MENU_CONTAINER_BACKGROUND = `${NS}-table-th-menu-container-background`;
export const TABLE_TH_MENU_OPEN = `${NS}-table-th-menu-open`;
export const TABLE_TH_MENU_SELECT_CELLS = `${NS}-table-th-menu-select-cells`;
export const TABLE_THEAD = `${NS}-table-thead`;
export const TABLE_TOP_CONTAINER = `${NS}-table-top-container`;
export const TABLE_TRUNCATED_CELL = `${NS}-table-truncated-cell`;
export const TABLE_TRUNCATED_FORMAT = `${NS}-table-truncated-format`;
export const TABLE_TRUNCATED_FORMAT_TEXT = `${NS}-table-truncated-format-text`;
export const TABLE_TRUNCATED_POPOVER = `${NS}-table-truncated-popover`;
export const TABLE_TRUNCATED_POPOVER_TARGET = `${NS}-table-truncated-popover-target`;
export const TABLE_TRUNCATED_TEXT = `${NS}-table-truncated-text`;
export const TABLE_TRUNCATED_VALUE = `${NS}-table-truncated-value`;
export const TABLE_VERTICAL_GUIDE = `${NS}-table-vertical-guide`;

/** Common code for row and column index class generator functions, since they're essentially the same. */
function dimensionIndexClass(classPrefix: string, index: string | number) {
    if (typeof index === "number") {
        return `${classPrefix}${index}`;
    }

    return index.indexOf(classPrefix) === 0 ? index : `${classPrefix}${index}`;
}

/** Return CSS class for table colummn index, whether or not 'pt-table-col-' prefix is included. */
export function columnIndexClass(columnIndex: string | number) {
    return dimensionIndexClass(`${NS}-table-col-`, columnIndex);
}

/** Return CSS class for table row index, whether or not 'pt-table-row-' prefix is included. */
export function rowIndexClass(rowIndex: string | number) {
    return dimensionIndexClass(`${NS}-table-row-`, rowIndex);
}

/** Return CSS class for table colummn cell index, whether or not 'pt-table-cell-col-' prefix is included. */
export function columnCellIndexClass(columnIndex: string | number) {
    return dimensionIndexClass(`${NS}-table-cell-col-`, columnIndex);
}

/** Return CSS class for table row cell index, whether or not 'pt-table-cell-row-' prefix is included. */
export function rowCellIndexClass(rowIndex: string | number) {
    return dimensionIndexClass(`${NS}-table-cell-row-`, rowIndex);
}
