<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Sine

> Compute the [sine][sine] of a number.

<section class="usage">

## Usage

```javascript
var sin = require( '@stdlib/math/base/special/sin' );
```

#### sin( x )

Computes the [sine][sine] of a `number` (in radians).

```javascript
var v = sin( 0.0 );
// returns ~0.0

v = sin( 3.141592653589793/2.0 );
// returns ~1.0

v = sin( -3.141592653589793/6.0 );
// returns ~-0.5
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- eslint no-undef: "error" -->

```javascript
var linspace = require( '@stdlib/array/linspace' );
var TWO_PI = require( '@stdlib/constants/float64/two-pi' );
var sin = require( '@stdlib/math/base/special/sin' );

var x = linspace( 0.0, TWO_PI, 100 );
var i;

for ( i = 0; i < x.length; i++ ) {
    console.log( sin( x[ i ] ) );
}
```

</section>

<!-- /.examples -->

<section class="links">

[sine]: https://en.wikipedia.org/wiki/Sine

</section>

<!-- /.links -->
