/*
 * Copyright (c) 2015 Cisco Systems, Inc.  All rights reserved.
 * Copyright (c) 2017      Intel, Inc.  All rights reserved.
 * Copyright (c) 2021      Nanook Consulting.  All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */

#ifndef PMIX_DL_LIBLTDL
#define PMIX_DL_LIBLTDL

#include "pmix_config.h"

#include "pmix/mca/dl/dl.h"

#include <ltdl.h>

PMIX_DECLSPEC extern pmix_pdl_base_module_t pmix_pdl_plibltpdl_module;

/*
 * Dynamic library handles generated by this component.
 *
 * If we're debugging, keep a copy of the name of the file we've opened.
 */
struct pmix_pdl_handle_t {
    lt_dlhandle ltpdl_handle;
#if PMIX_ENABLE_DEBUG
    char *filename;
#endif
};

typedef struct {
    pmix_pdl_base_component_t base;

#if PMIX_DL_LIBLTDL_HAVE_LT_DLADVISE
    /* If the version of plibltdl that we are compiling against has
       lt_dladvise, use it to support opening DSOs in a variety of
       modes. */
    lt_dladvise advise_private_noext;
    lt_dladvise advise_private_ext;
    lt_dladvise advise_public_noext;
    lt_dladvise advise_public_ext;
#endif
} pmix_pdl_plibltpdl_component_t;

PMIX_DECLSPEC extern pmix_pdl_plibltpdl_component_t mca_pdl_plibltpdl_component;

#endif /* PMIX_DL_LIBLTDL */
