## -*- mode: autoconf -*-

dnl
dnl This file is part of the Score-P software (http://www.score-p.org)
dnl
dnl Copyright (c) 2015, 2017, 2020, 2023,
dnl Technische Universitaet Dresden, Germany
dnl
dnl This software may be modified and distributed under the terms of
dnl a BSD-style license.  See the COPYING file in the package base
dnl directory for details.
dnl

AC_ARG_VAR([PYTHON],
           [The Python interpreter to be used for the Python bindings. Use PYTHON=: to disable Python support.])
m4_define_default([_AM_PYTHON_INTERPRETER_LIST],
                  [python3 python3.10 python3.9 python3.8 python3.7 python3.6 dnl
                   python])
AM_PATH_PYTHON([3.6], , [:])

rm -f python_bindings_supported
otf2_have_python_bindings_support=yes
otf2_python_bindings_reason=", using $PYTHON"

AS_IF([test "x${PYTHON}" = "x:"], [
    otf2_have_python_bindings_support=no
    otf2_python_bindings_reason=", missing python"
])

AS_IF([test "x${otf2_have_python_bindings_support}" = "xyes" && test "x${enable_shared}" != "xyes"], [
    otf2_have_python_bindings_support=no
    otf2_python_bindings_reason=", missing shared library support"
])

AS_IF([test "x${otf2_have_python_bindings_support}" = "xyes"], [
    touch python_bindings_supported
])
AFS_AM_CONDITIONAL([HAVE_PYTHON_BINDINGS_SUPPORT],
                   [test "x${otf2_have_python_bindings_support}" = "xyes"],
                   [false])
AFS_SUMMARY([Python bindings support], [${otf2_have_python_bindings_support}${otf2_python_bindings_reason}])

AC_SUBST([OTF2_PYTHON_BINDINGS_SUPPORT], [${otf2_have_python_bindings_support}])
AM_SUBST_NOTMAKE([OTF2_PYTHON_BINDINGS_SUPPORT])
