/**
 * @file
 *
 * @author jeffrey.daily@gmail.com
 *
 * Copyright (c) 2015 Battelle Memorial Institute.
 *
 * This file was converted to C code from the raw file found at
 * ftp://ftp.cbi.pku.edu.cn/pub/software/blast/matrices/PAM180, the
 * Center for Bioinformatics, Peking University, China.
 */
#ifndef _PARASAIL_PAM180_H_
#define _PARASAIL_PAM180_H_

#include "parasail.h"
#include "pam_map.h"

#ifdef __cplusplus
extern "C" {
#endif

/* # */
/* # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93] */
/* # */
/* # PAM 180 substitution matrix, scale = ln(2)/3 = 0.231049 */
/* # */
/* # Expected score = -1.51, Entropy = 0.591 bits */
/* # */
/* # Lowest score = -10, Highest score = 18 */
/* # */

static const int parasail_pam180_[] = {
/*        A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   * */
/* A */   3, -3,  0,  0, -3, -1,  0,  1, -2, -1, -3, -2, -2, -5,  1,  1,  2, -8, -5,  0,  0,  0, -1,-10,
/* R */  -3,  8, -1, -3, -5,  1, -2, -4,  2, -3, -4,  4, -1, -6, -1, -1, -2,  2, -6, -4, -2,  0, -2,-10,
/* N */   0, -1,  4,  3, -5,  0,  2,  0,  2, -3, -4,  1, -3, -5, -1,  1,  0, -5, -2, -3,  3,  1, -1,-10,
/* D */   0, -3,  3,  5, -7,  2,  4,  0,  0, -3, -6,  0, -4, -8, -2,  0, -1, -9, -6, -3,  4,  3, -1,-10,
/* C */  -3, -5, -5, -7, 13, -7, -7, -5, -4, -3, -8, -7, -7, -6, -4,  0, -3,-10,  0, -3, -6, -7, -4,-10,
/* Q */  -1,  1,  0,  2, -7,  6,  3, -2,  4, -3, -2,  0, -1, -6,  0, -1, -2, -6, -6, -3,  1,  5, -1,-10,
/* E */   0, -2,  2,  4, -7,  3,  5,  0,  0, -3, -5, -1, -3, -7, -1, -1, -1, -9, -6, -3,  3,  5, -1,-10,
/* G */   1, -4,  0,  0, -5, -2,  0,  6, -3, -4, -6, -3, -4, -6, -1,  1, -1, -9, -7, -2,  0, -1, -2,-10,
/* H */  -2,  2,  2,  0, -4,  4,  0, -3,  8, -4, -3, -1, -3, -3, -1, -2, -2, -4,  0, -3,  1,  2, -1,-10,
/* I */  -1, -3, -3, -3, -3, -3, -3, -4, -4,  6,  2, -3,  2,  1, -3, -2,  0, -7, -2,  5, -3, -3, -1,-10,
/* L */  -3, -4, -4, -6, -8, -2, -5, -6, -3,  2,  7, -4,  4,  1, -4, -4, -3, -3, -2,  2, -5, -3, -2,-10,
/* K */  -2,  4,  1,  0, -7,  0, -1, -3, -1, -3, -4,  6,  1, -7, -2, -1,  0, -5, -6, -4,  0,  0, -1,-10,
/* M */  -2, -1, -3, -4, -7, -1, -3, -4, -3,  2,  4,  1,  9,  0, -3, -2, -1, -6, -4,  2, -3, -2, -1,-10,
/* F */  -5, -6, -5, -8, -6, -6, -7, -6, -3,  1,  1, -7,  0, 10, -6, -4, -4,  0,  7, -2, -6, -7, -3,-10,
/* P */   1, -1, -1, -2, -4,  0, -1, -1, -1, -3, -4, -2, -3, -6,  8,  1,  0, -7, -7, -2, -2, -1, -1,-10,
/* S */   1, -1,  1,  0,  0, -1, -1,  1, -2, -2, -4, -1, -2, -4,  1,  3,  2, -3, -4, -2,  1, -1,  0,-10,
/* T */   2, -2,  0, -1, -3, -2, -1, -1, -2,  0, -3,  0, -1, -4,  0,  2,  4, -7, -4,  0,  0, -1, -1,-10,
/* W */  -8,  2, -5, -9,-10, -6, -9, -9, -4, -7, -3, -5, -6,  0, -7, -3, -7, 18, -1, -8, -7, -8, -6,-10,
/* Y */  -5, -6, -2, -6,  0, -6, -6, -7,  0, -2, -2, -6, -4,  7, -7, -4, -4, -1, 11, -4, -4, -6, -3,-10,
/* V */   0, -4, -3, -3, -3, -3, -3, -2, -3,  5,  2, -4,  2, -2, -2, -2,  0, -8, -4,  6, -3, -3, -1,-10,
/* B */   0, -2,  3,  4, -6,  1,  3,  0,  1, -3, -5,  0, -3, -6, -2,  1,  0, -7, -4, -3,  4,  3, -1,-10,
/* Z */   0,  0,  1,  3, -7,  5,  5, -1,  2, -3, -3,  0, -2, -7, -1, -1, -1, -8, -6, -3,  3,  5, -1,-10,
/* X */  -1, -2, -1, -1, -4, -1, -1, -2, -1, -1, -2, -1, -1, -3, -1,  0, -1, -6, -3, -1, -1, -1, -1,-10,
/* * */ -10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,  1
};

static const parasail_matrix_t parasail_pam180 = {
    "pam180",
    parasail_pam180_,
    parasail_pam_map,
    24,
    18,
    -10,
    NULL,
    PARASAIL_MATRIX_TYPE_SQUARE,
    24,
    "ARNDCQEGHILKMFPSTWYVBZX*",
    NULL
};

#ifdef __cplusplus
}
#endif

#endif /* _PARASAIL_PAM180_H_ */

