# 0.92 Release “Baby Steps”

The Pitivi team is proud to announce the second alpha release of the new
version of Pitivi based on [GES](GES.md), the GStreamer Editing
Services library. This is a incremental bugfixing release, so please
make sure to see the [0.91](releases/0.91.md) release notes to get the
full picture.

<span style="background:#FF0000">**WARNING**</span>: Please keep in mind
that this is still an *alpha* release, so there may be some bugs we
haven't found yet. We appreciate your feedback, so try it out, let us
know how well it works for you and report detailed bugs for issues you
may encounter. Again, this is <span style="color:#FF0000">not yet
considered production-ready software</span>.

That said, one month after [0.91](releases/0.91.md), with the feedback we
have received so far, we are pretty confident that the new release
series is of much higher quality than the [0.15](releases/0.15.md) series
and older.

## Changes and fixed bugs

Executive summary:

-   Fix a bug where transitions would stop working
-   Fix the handling of rendering parameters
-   Fixes for the keyframes UI in the timeline
-   Usability improvements for the welcome dialog
-   Update the preview immediately when adding an effect
-   Fixes for AppData XML spec compliance
-   Various build and packaging fixes
-   Drop the PyXDG dependency
-   Translations have been updated

See the list of [reported bugs that have been fixed in
0.92](https://bugzilla.gnome.org/buglist.cgi?product=pitivi;target_milestone=0.92).

General fixes:

```
e33598c ui/startupwizard: Force ButtonBox items to have a homogeneous/uniform width
b9f62d7 Keep the welcome dialog shown when clicking “Missing dependencies...”\
4dcbf5c elements: Set clip inpoints to prevent keyframes from breaking on split/trim
1de8d96 previewers: stop waveforms and thumbnails generation when removing clips
2cb9298 mainwindow: Make it possible to save project when an asset moved
bfe4154 project: Avoid to work with read only caps
79fb9ab render: Take into account video size scaling value when rendering
e43c54d project: Always set auto-transition to true on newly created timelines
dcb9b68 effects: Commit the timeline when adding an effect.
4936135 keyframes: If the length of the line is inferior to one pixel, don't draw it.
```

Build/packaging fixes:

```
c316cc1 Apply minor changes to make AppData XML file friendlier to distributions
8159d23 Drop dependency on PyXDG, use GLib instead
5c94a24 build: Don't attempt locale-uninstalled bits if DESTDIR is set
6490a95 bin: Fix GI_TYPELIB_PATH mistakes
308f18c bin: Build gst-devtools only if in developer mode
078b71b bin: Better handling of gst version and add default scenario path
306e880 bin: Do not build GI and PyGobject if not necessary
```

## Requirements

Dependencies/requirements have changed significantly since the 0.15
series, but have stayed mostly the same since [0.91](releases/0.91.md)
(pyxdg was dropped as a dependency).

Generally speaking, you can refer to Pitivi's check.py for the
dependencies' versions specific to a given release. See also
[dependencies](attic/Dependencies.md) for additional tips.

## Known issues

Please see the [0.91](releases/0.91.md) release notes.

See the list of [currently known
issues](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced;bug_severity=blocker;bug_severity=critical;bug_severity=major;bug_severity=normal;bug_severity=minor;bug_severity=trivial;bug_status=NEW;bug_status=ASSIGNED;bug_status=REOPENED;product=pitivi),
the [0.91 and 0.92-specific
issues](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced&version=0.91&version=0.92&resolution=---&product=pitivi)
and the list of [bugs that need re-testing with 0.91 and
0.92](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced;bug_status=NEEDINFO;target_milestone=0.91;target_milestone=0.92;product=pitivi)
(you can help!)

# Contributors for this release

In Pitivi:

```
9  Thibault Saunier
6  Jean-François Fortin Tam
6  Mathieu Duponchelle
3  Colin Walters
```

In GES:

```
5  Thibault Saunier
2  Kishore Arepalli
2  Mathieu Duponchelle
```

Translations:

```
   cs  Marek Černocký
   es  Daniel Mustieles
   fi  Timo Jyrinki
   fr  Claude Paroz
   gl  Fran Diéguez
   lv  Rūdolfs Mazurs
pt_BR  Rafael Ferreira
   sl  Martin Srebotnjak
   sr  Мирослав Николић
zh_HK  Cheng-Chia Tseng
zh_TW  Cheng-Chia Tseng
```

# Download, additional information and feedback

A tarball is available on
<http://ftp.gnome.org/pub/GNOME/sources/pitivi/0.92/>

See [the Pitivi website](http://www.pitivi.org) and [building with
GES](attic/building_with_ges.md) for download and installation
instructions.

Feedback is welcome. See [bug reporting](Bug_reporting.md) for
tips and tricks.
