# About pip's Users

## Problem

We want to understand users' background, their cultural environment, and how they experience the world, so that we can find better ways to serve them.

[Skip to recommendations](#recommendations)

## Research

To develop our understanding about pip's users, we published a "Who uses pip?" survey that asked users about:

- Their location in the world
- Their spoken language
- If they identified as members of an underrepresented group in the Python community
- Their disabilities and if those disabilities affected their usage of pip

## Results

164 people responded to the survey, with 40% of these coming from English speaking countries. 80% of participants came from Europe or North America.

Approx. 60% did not identify as members of an underrepresented group. The majority of participants who did identify as underrepresented did so for gender reasons.

The majority of participants (94%) responded that they did not have a disability. Of those that did have a disability, the majority were cognitive disabilities (Attention Deficit Hyperactivity Disorder aka ADHD, Autism, Aspergers, Dyslexia) or a hearing disability.

### Participant Demographics

#### Location

The majority of participants came from North America and Western Europe. Participation from pip users in Africa, Asia, and the Middle-East was low.

![Map of world showing distribution of participants as per table below](https://i.imgur.com/U2MYiK7.png)

Fig. X: Global distribution of pip research participants.

| Country Name             | Number of participants |
| ------------------------ | ---------------------- |
| United States of America | 42                     |
| United Kingdom           | 17                     |
| France                   | 12                     |
| Germany                  | 11                     |
| Canada                   | 10                     |
| Netherlands              | 8                      |
| Spain                    | 6                      |
| Switzerland              | 5                      |
| Nigeria                  | 4                      |
| India                    | 4                      |
| Czech Republic           | 4                      |
| Argentina                | 4                      |
| Sweden                   | 3                      |
| Australia                | 3                      |
| Ukraine                  | 2                      |
| Taiwan                   | 2                      |
| Russia                   | 2                      |
| Greece                   | 2                      |
| Colombia                 | 2                      |
| Chile                    | 2                      |
| Brazil                   | 2                      |
| Belgium                  | 2                      |
| Uganda                   | 1                      |
| Turkey                   | 1                      |
| Singapore                | 1                      |
| Serbia                   | 1                      |
| Norway                   | 1                      |
| Luxembourg               | 1                      |
| Japan                    | 1                      |
| Italy                    | 1                      |
| Israel                   | 1                      |
| Ireland                  | 1                      |
| Hungary                  | 1                      |
| Ghana                    | 1                      |
| Finland                  | 1                      |
| Bulgaria                 | 1                      |
| Austria                  | 1                      |
| Total                    | 164                    |

#### Participant's First Language

Even though the research was carried out mainly in English, 51% of participants spoke languages other than English.

| What spoken language do you feel is your first? | Number of participants |
| ----------------------------------------------- | ---------------------- |
| English                                         | 79                     |
| French                                          | 18                     |
| Spanish                                         | 12                     |
| German                                          | 11                     |
| Russian                                         | 5                      |
| Czech                                           | 4                      |
| Italian                                         | 4                      |
| Portuguese                                      | 3                      |
| Dutch                                           | 3                      |
| Ukrainian                                       | 2                      |
| Swedish                                         | 2                      |
| Greek                                           | 2                      |
| Catalan                                         | 2                      |
| Mandarin                                        | 2                      |
| Hungarian                                       | 2                      |
| Bengali                                         | 1                      |
| Luxembourgish                                   | 1                      |
| Bulgarian                                       | 1                      |
| Romanian                                        | 1                      |
| Chinese                                         | 1                      |
| Norwegian                                       | 1                      |
| Serbian                                         | 1                      |
| Polish                                          | 1                      |
| Hebrew                                          | 1                      |
| Indonesian                                      | 1                      |
| Malayalam                                       | 1                      |

NB: English includes British English and American English. Some participants gave more than one answer, their first answer is included here.

### Participants who identified as underrepresented in the Python community

We asked research participants if they identified as members of an underrepresented group within the Python community.

The wording of this question was deliberately broad to discover participants' understanding of the term "underrepresented" - we listed gender, age, educational background, spoken language, and what they use Python for as a non-exhaustive list of examples.

![Pie chart showing 17.9% answering - I am not sure, 22.6% answering  -yes, 59.4% answering - No to the question - Do you identify as an underrepresented group in the Python community](https://i.imgur.com/ghwzxg9.png)

Of the 22.6% that responded "Yes" the answers were classified as follows :

| Underrepresentation category | Count |
| ---------------------------- | ----- |
| Gender                       | 9     |
| Cultural                     | 3     |
| Age                          | 3     |
| Immigration status           | 2     |
| Neurodiversity               | 3     |
| Other                        | 6     |
| No answer                    | 8     |

NB: This question was included after the survey was published. Total participants was 106, as opposed to all other questions which had 164.

The majority of participants did not identify as part of an underrepresented group. However, due to the small sample size these results cannot be seen as representative of the whole pip user base.

#### Participant comments about identifying (or not) as under-represented

Here is a sample of noteworthy comments from these different groups:

##### Related to Gender

> "(I am) LGBTQ/IA+" **- Participant 242608909**

> "I am a 25 year old female Colombian developer." **- Participant 242611698**

> "Female, 39, no computer science background whatsoever, self taught." **- Participant 242614039**

##### Related to Culture

> "The hispanic community is quite underrepresented in the web in general" **- Participant 242599212**

> "I am a 1st generation Dominican-American. My parents are from the Dominican Republic." **- Participant 242769361**

##### Related to Age

> "Older age, I am 50 now." **- Participant 242769743**

##### Related to Neurodiversity

> "I'm a woman. And autistic. But the latter might not be underrepresented ;)" **- Participant 243428773**

##### Other Noteworthy Comments

> "Veterans who entered tech post-military" **- Participant 243524784**

> "I'm a young white cis male, so by far not a minority in those aspects. But at the same time I'm from a third world country, Argentina, and that sometimes (and I emphasize, only sometimes) makes me feel like a minority. When participating in our local communities (Python Argentina), I feel clearly not-minority, and with the responsibility of helping minorities, trying to build a more welcoming and fair environment for them. But when I participate in the broader global community, at times I feel underrepresented, seeing it mostly guided by english-s[p]eaking people from first world countries. But if I have to choose, I would say I mostly feel not-minority, because I mostly interact with people from our local communities, where I'm not part of a minority." **- Participant 242592869**

> "As a CIS male I conform the majoritarian group in the IT world. I'm hopeful that things are changing everywhere, and will keep changing: inclusion is getting bigger and better, more and more people are starting their careers as devs or similar, disregarding ethnicity and/or sexual orientation and that's great! And we need to keep fighting for that." **- Participant 243455292**

### Participant Disabilities

Disabilities - physical, motor, cognitive, hearing, speech - alter how people perceive and interact with the world around them - software included. We asked participants about their disabilities and how it affected their usage of pip.

Understanding these disabilities is important particularly when designing pip command structures, and designing pip output.

The majority of participants (91%) responded that they did not have a disability. Of those that told us that have a disability, the majority were cognitive disabilities (Attention Deficit Hyperactivity Disorder (ADHD), Autism, Aspergers, Dyslexia, or a hearing disability.

#### How many participants identified as having a disability?

| Do you self-identify as someone who has a disability? | Number of responses |
| ----------------------------------------------------- | ------------------- |
| No                                                    | 150                 |
| Yes                                                   | 14                  |
| Grand Total                                           | 164                 |

#### Vision

Participants who answered yes to this question were partially sighted. Their vision disability was not corrected by glasses, but did not significantly affect their usage of pip.

#### Hearing

Five participants identified as having a hearing impairment, or hearing loss. While this disability made participants lives more difficult, it did not affect their usage of pip:

> "Being hard of hearing/impaired makes my life much harder, but so far it never has impacted my usage of pip. Perhaps because I haven‘t used parts of it that would?" **- Participant 242934019**

> "Not at all given that everything happens by text in my console." **- Participant 243455292**

However it did affect the way they consume pip learning materials: if video is being used for learning or support, they should have captions/subtitles/transcriptions available.

> "any videos released, it is so helpful if there is either a) transcripts, or b) captions." **- Participant 243524784**

#### Cognitive Disabilities

Nine participants expressed cognitive disabilities including undefined mental health conditions, Attention Deficit Hyperactivity Disorder (ADHD), Autism, Aspergers, Dyslexia.

These participants did not explain how their cognitive disabilities affect their usage of pip, however there are guidelines and best practices for designing for people with cognitive disabilities.

#### Physical or Mobility Disability

One participant responded that they had a physical or mobility disability, but did not give detail about it in relation to their usage of pip.

### Participants use of Assistive Technology

The term "assistive technology" (AT) is used to describe products or systems that support and assist individuals with disabilities, restricted mobility or other impairments to perform functions that might otherwise be difficult or impossible. A subset of these are used to make computer technology - hardware and software - more accessible. Common examples of AT used with computer technology are: screen readers, text-to-speech outputs/inputs.

The majority of participants (94%) said that they have never used assistive technology.

| Do you use assistive technology (AT) when using computers? | Number of responses |
| ---------------------------------------------------------- | ------------------- |
| No, I have never used it                                   | 128                 |
| I only use it when needed                                  | 3                   |
| I use it everyday                                          | 1                   |
| I have used it in the past, but not anymore                | 4                   |

Of the eight participants who have used assistive technology, one participant uses assistive technology every day with:

- Text-to-speech output as "text to speech allow(s) me to listen and learn when my eyes get strained."
- Speech-to-text input as they like using their "tablet and makes typing easier"
- On-screen keyboards
- Input switches/touch screens

A further seven participants use assistive technology only as needed:

> "I use custom display filter software to do things like colorize key lines of output automatically (to draw my eye/attention), and provide digit dilimination (I.E. help me tell 1000 and 10000 apart) when using a text console application."

> "The standard Mac user interface design contains enough assistive technology without my needing to use any features which are specifically intended solely as assistive functions."

> "I sometimes use it to make sure that my code will work correctly with AT."

#### Operating systems used with assistive technology

Participants use assistive technology across the three most popular desktop operating systems - Linux (most popular), Windows (2nd most popular), and Mac.

![Pie chart showing breakdown of most popular operating systems for pip users using assistive technology](https://i.imgur.com/CD2ev5P.png)

#### Assistive technology when using pip

We asked participants how well their assistive technologies worked when they use pip. All participants using assistive technology with pip said it worked well for them.

We received some feedback about screen readers not coping well with long output, with users experiencing difficulties accessing content at the top of the current terminal window. Therefore, commands or actions (e.g. pip help, pip install, failed builds) that generate a lot of content can be a problem for screenreader users.

## Recommendations

### Supporting languages other than English

As 51% of participants speak a language other than English, we recommend that the pip team add localization support to the pip documentation and reach out to the community to find pip users who might be willing to contribute translations. Translators that have [contributed translations to PyPI](https://hosted.weblate.org/projects/pypa/warehouse/) may be a good starting point.

If this is not possible, we recommend linking to useful resources in languages other than English from the pip documentation, as we know from our other research that users use a mixture of the official documentation, search engine searches, Stack Overflow and blogs/websites to find solutions to their problems.

### Supporting pip users with disabilities

Pip's operation is generally very good for users with disabilities. Being a command line application there are no distracting images or ancillary content, and the user has a large amount of control on how they experience pip via customisation of interface visual preferences (to use contrasting colours, font size and type) and visual and auditory alerts.

To better support pip's users with disabilities, the pip team should:

- Ensure any future video or audio support materials are provided with captions
- Improve pip's output (see below)

### Improving pip output

Pip's output is currently too verbose, generating an unhelpful amount of output during its operation. This causes usability issues for all users - especially users with cognitive disabilities.

Pip's output should be improved by:

- Retaining only the information that is important to users in their current moment (e.g. at install of a package)
- Removing unimportant information from the terminal output. The information can still be logged to the log files if needed.
- Reducing the number of verbosity levels to three. Right now there are seven levels of verbosity, which is overwhelming and in no way useful. We recommend:
  - Verbosity 0 - shows only what packages are to be installed, notifications identified as important about the operation, any errors and the final outcome
  - Verbosity 1 - shows more detail about the packages being installed
  - Verbosity 2 - shows full information which is also logged to logfiles

## Further reading

Designing for people with disabilities:

- [An Introduction to inclusive design](https://www.nomensa.com/blog/2011/introduction-inclusive-design)
- [How ADHD and dyslexia teach you to do better UX design](https://themasters.io/blog/posts/how-adhd-dyslexia-teach-better-ux-design)
- [Improve User Experience by Designing with Cognitive Differences in Mind](https://noti.st/elizabethschafer/fg3BR4)
- [Designing accessible software - guidelines for different disabilities](https://ukhomeoffice.github.io/accessibility-posters/)
- [Designing for Children with ADHD: The Search for Guidelines for Non-Experts](https://uxpamagazine.org/designing_children_adhd/) (written for children however applicable generally)
- [Designing for dyslexia](https://uxplanet.org/designing-for-dyslexia-6d12e8c41cd7)
