% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringConvenience.R
\docType{methods}
\name{presAbsCall,RccSet-method}
\alias{presAbsCall,RccSet-method}
\alias{presAbsCall}
\title{Presence/absence call}
\usage{
\S4method{presAbsCall}{RccSet}(rccSet, stringency = 2,
  inputMatrix = c("posCtrlData", "exprs"), quietly = FALSE)
}
\arguments{
\item{rccSet}{An RccSet with background-corrected data.}

\item{stringency}{Multiplier to use in establishing the presence/absence call as
mentioned in the description.}

\item{inputMatrix}{Name of the matrix in the RccSet's assayData on which to apply the
presence/absence call (either "posCtrlData" or "exprs").}

\item{quietly}{Logical. If TRUE, messages and warnings will not be shown.}
}
\value{
A copy of the input is returned with a new matrix named `paData' added to
the assayData that contains the presence/absence calls.
}
\description{
Adds a matrix to assayData (`paData') which indicates the presence/absence
call for each gene in each sample using the background estimates and
a stringency value. A gene is considered present in a sample if
its count in that sample exceeds the corresponding background estimate
times the stringency. The count values can be taken from either the
positive control normalized data or the raw data (see
the inputMatrix agrument). If the input doesn't contain background-corrected
data, an error will be generated.
}
\examples{
data(example_rccSet)
pcnorm_rccSet <- posCtrlNorm(example_rccSet)
bgEst <- getBackground(pcnorm_rccSet)
bgcorr_rccSet <- subtractBackground(pcnorm_rccSet, bgEst)
pa_rccset <- presAbsCall(bgcorr_rccSet)

}
