% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitsort.R
\name{bit_unidup}
\alias{bit_unidup}
\alias{bit_unique}
\alias{bit_duplicated}
\alias{bit_anyDuplicated}
\alias{bit_sumDuplicated}
\title{bit unique and duplicated}
\usage{
bit_unique(x, na.rm = NA, range_na = NULL)

bit_duplicated(x, na.rm = NA, range_na = NULL, retFUN = as.bit)

bit_anyDuplicated(x, na.rm = NA, range_na = NULL)

bit_sumDuplicated(x, na.rm = NA, range_na = NULL)
}
\arguments{
\item{x}{an integer vector}

\item{na.rm}{\code{NA} treats NAs like other integers, \code{TRUE} treats
\emph{all} NAs as duplicates, \code{FALSE} treats \emph{no} NAs as
duplicates}

\item{range_na}{\code{NULL} calls \code{\link[=range_na]{range_na()}}, optionally the result of \code{\link[=range_na]{range_na()}} can be
given here to avoid calling it again}

\item{retFUN}{a function that coerces \code{\link[=bit]{bit()}} and \code{\link[=logical]{logical()}} vectors}
}
\value{
\itemize{
\item \code{bit_unique} returns a vector of unique integers,
\item \code{bit_duplicated} returns a boolean vector coerced to \code{retFUN},
\item \code{bit_anyDuplicated} returns the position of the first duplicate (or zero if no
duplicates)
\item \code{bit_sumDuplicated} returns the number of duplicated values (as.integer)
}
}
\description{
Fast versions of \code{\link[=unique]{unique()}}, \code{\link[=duplicated]{duplicated()}} ,
\code{\link[=anyDuplicated]{anyDuplicated()}} and \code{sum(duplicated(x))} for integers.
}
\details{
determines the range of the integers and checks if the density justifies use
of a bit vector; if yes, uses a bit vector for finding duplicates; if no,
falls back to \code{\link[=unique]{unique()}}, \code{\link[=duplicated]{duplicated()}}, \code{\link[=anyDuplicated]{anyDuplicated()}} and \code{sum(duplicated(x))}
}
\section{Functions}{
\itemize{
\item \code{bit_unique()}: extracts unique elements

\item \code{bit_duplicated()}: determines duplicate elements

\item \code{bit_anyDuplicated()}: checks for existence of duplicate elements

\item \code{bit_sumDuplicated()}: counts duplicate elements

}}
\examples{
bit_unique(c(2L, 1L, NA, NA, 1L, 2L))
bit_unique(c(2L, 1L, NA, NA, 1L, 2L), na.rm=FALSE)
bit_unique(c(2L, 1L, NA, NA, 1L, 2L), na.rm=TRUE)

bit_duplicated(c(2L, 1L, NA, NA, 1L, 2L))
bit_duplicated(c(2L, 1L, NA, NA, 1L, 2L), na.rm=FALSE)
bit_duplicated(c(2L, 1L, NA, NA, 1L, 2L), na.rm=TRUE)

bit_anyDuplicated(c(2L, 1L, NA, NA, 1L, 2L))
bit_anyDuplicated(c(2L, 1L, NA, NA, 1L, 2L), na.rm=FALSE)
bit_anyDuplicated(c(2L, 1L, NA, NA, 1L, 2L), na.rm=TRUE)

bit_sumDuplicated(c(2L, 1L, NA, NA, 1L, 2L))
bit_sumDuplicated(c(2L, 1L, NA, NA, 1L, 2L), na.rm=FALSE)
bit_sumDuplicated(c(2L, 1L, NA, NA, 1L, 2L), na.rm=TRUE)
}
\seealso{
\code{\link[=bit_sort_unique]{bit_sort_unique()}}
}
