% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_optim.R
\name{multi_optim}
\alias{multi_optim}
\title{Multiple starts for Regularized Structural Equation Modeling}
\usage{
multi_optim(model, max.try = 10, lambda = 0, alpha = 0.5,
  gamma = 3.7, random.alpha = 0.5, LB = -Inf, UB = Inf,
  par.lim = c(-Inf, Inf), block = TRUE, full = TRUE,
  type = "lasso", optMethod = "rsolnp", gradFun = "ram",
  pars_pen = "regressions", diff_par = NULL, hessFun = "none",
  tol = 1e-05, round = 3, solver = FALSE, quasi = FALSE,
  solver.maxit = 50000, alpha.inc = FALSE, line.search = FALSE,
  prerun = FALSE, step = 0.1, momentum = FALSE, step.ratio = FALSE,
  verbose = FALSE, warm.start = FALSE, Start2 = NULL,
  nlminb.control = NULL, max.iter = 500)
}
\arguments{
\item{model}{Lavaan output object. This is a model that was previously
run with any of the lavaan main functions: cfa(), lavaan(), sem(),
or growth(). It also can be from the efaUnrotate() function from
the semTools package. Currently, the parts of the model which cannot
be handled in regsem is the use of multiple group models, missing
other than listwise, thresholds from categorical variable models,
the use of additional estimators other than
ML, most notably WLSMV for categorical variables. Note: the model
does not have to actually run (use do.fit=FALSE), converge etc...
regsem() uses the lavaan object as more of a parser and to get
sample covariance matrix.}

\item{max.try}{number of starts to try before convergence.}

\item{lambda}{Penalty value. Note: higher values will result in additional
convergence issues.}

\item{alpha}{Mixture for elastic net.}

\item{gamma}{Additional penalty for MCP and SCAD}

\item{random.alpha}{Alpha parameter for randomised lasso. Has to be between
0 and 1, with a default of 0.5. Note this is only used for
"rlasso", which pairs with stability selection.}

\item{LB}{lower bound vector. Note: This is very important to specify
when using regularization. It greatly increases the chances of
converging.}

\item{UB}{Upper bound vector}

\item{par.lim}{Vector of minimum and maximum parameter estimates. Used to
stop optimization and move to new starting values if violated.}

\item{block}{Whether to use block coordinate descent}

\item{full}{Whether to do full gradient descent or block}

\item{type}{Penalty type. Options include "none", "lasso",
"enet" for the elastic net,
"alasso" for the adaptive lasso
and "diff_lasso". If ridge penalties are desired, use type="enet" and
alpha=1. diff_lasso penalizes the discrepency between
parameter estimates and some pre-specified values. The values
to take the deviation from are specified in diff_par. Two methods for
sparser results than lasso are the smooth clipped absolute deviation,
"scad", and the minimum concave penalty, "mcp". Last option is "rlasso"
which is the randomised lasso to be used for stability selection.}

\item{optMethod}{Solver to use. Two main options for use: rsoolnp and coord_desc.
Although slightly slower, rsolnp works much better for complex models.
coord_desc uses gradient descent with soft thresholding for the type of
of penalty. Rsolnp is a nonlinear solver that doesn't rely on gradient
information. There is a similar type of solver also available for use,
slsqp from the nloptr package. coord_desc can also be used with hessian
information, either through the use of quasi=TRUE, or specifying a hess_fun.
However, this option is not recommended at this time.}

\item{gradFun}{Gradient function to use. Recommended to use "ram",
which refers to the method specified in von Oertzen & Brick (2014).
Only for use with optMethod="coord_desc".}

\item{pars_pen}{Parameter indicators to penalize. There are multiple ways to specify.
The default is to penalize all regression parameters ("regressions"). Additionally,
one can specify all loadings ("loadings"), or both c("regressions","loadings").
Next, parameter labels can be assigned in the lavaan syntax and passed to pars_pen.
See the example.Finally, one can take the parameter numbers from the A or S matrices and pass these
directly. See extractMatrices(lav.object)$A.}

\item{diff_par}{Parameter values to deviate from. Only used when
type="diff_lasso".}

\item{hessFun}{Hessian function to use. Currently not recommended.}

\item{tol}{Tolerance for coordinate descent}

\item{round}{Number of digits to round results to}

\item{solver}{Whether to use solver for coord_desc}

\item{quasi}{Whether to use quasi-Newton. Currently not recommended.}

\item{solver.maxit}{Max iterations for solver in coord_desc}

\item{alpha.inc}{Whether alpha should increase for coord_desc}

\item{line.search}{Use line search for optimization. Default is no, use fixed step size}

\item{prerun}{Logical. Use rsolnp to first optimize before passing to
gradient descent? Only for use with coord_desc.}

\item{step}{Step size}

\item{momentum}{Momentum for step sizes}

\item{step.ratio}{Ratio of step size between A and S. Logical}

\item{verbose}{Whether to print iteration number.}

\item{warm.start}{Whether start values are based on previous iteration.
This is not recommended.}

\item{Start2}{Provided starting values. Not required}

\item{nlminb.control}{list of control values to pass to nlminb}

\item{max.iter}{Number of iterations for coordinate descent}
}
\description{
Multiple starts for Regularized Structural Equation Modeling
}
\examples{
\dontrun{
# Note that this is not currently recommended. Use cv_regsem() instead
library(regsem)
# put variables on same scale for regsem
HS <- data.frame(scale(HolzingerSwineford1939[ ,7:15]))
mod <- '
f =~ x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9
'
outt = cfa(mod, HS, meanstructure=TRUE)

fit1 <- multi_optim(outt, max.try=40,
                   lambda=0.1, type="lasso")


# growth model
model <- ' i =~ 1*t1 + 1*t2 + 1*t3 + 1*t4
          s =~ 0*t1 + s1*t2 + s2*t3 + 3*t4 '
fit <- growth(model, data=Demo.growth)
summary(fit)
fitmeasures(fit)
fit3 <- multi_optim(fit, lambda=0.2, type="lasso")
summary(fit3)
}
}
\keyword{multiple}
\keyword{optim}
