% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{baseHaz_cpp}
\alias{baseHaz_cpp}
\title{C++ Fast Baseline Hazard Estimation}
\usage{
baseHaz_cpp(
  starttimes,
  stoptimes,
  status,
  eXb,
  strata,
  predtimes,
  emaxtimes,
  nPatients,
  nStrata,
  cause,
  Efron
)
}
\arguments{
\item{starttimes}{a vector of times (begin at risk period).}

\item{stoptimes}{a vector of times (end at risk period).}

\item{status}{a vector indicating  censoring or event.}

\item{eXb}{a numeric vector (exponential of the linear predictor).}

\item{strata}{a vector of integers (index of the strata for each observation).}

\item{predtimes}{a vector of times (time at which to evaluate the hazard). Must be sorted.}

\item{emaxtimes}{another vector of times, one per strata (last observation time in each strata).}

\item{nPatients}{number of observations.}

\item{nStrata}{number of strata}

\item{cause}{the status value corresponding to event.}

\item{Efron}{whether Efron or Breslow estimator should be used in presence of ties.}
}
\description{
C++ function to estimate the baseline hazard from a Cox Model
}
\details{
WARNING stoptimes status eXb and strata must be sorted by strata, stoptimes, and status
}
