// Copyright 2017 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

#![feature(match_default_bindings)]

fn with_u8() {
    let s = 5u8;
    let r = match &s {
        4 => false,
        5 => true,
        _ => false,
    };
    assert!(r);
}

// A string literal isn't mistaken for a non-ref pattern (in which case we'd
// deref `s` and mess things up).
fn with_str() {
    let s: &'static str = "abc";
    match s {
            "abc" => true,
            _ => panic!(),
    };
}

// Ditto with byte strings.
fn with_bytes() {
    let s: &'static [u8] = b"abc";
    match s {
        b"abc" => true,
        _ => panic!(),
    };
}

pub fn main() {
    with_str();
}
