package test;

public class Main {

	public String getRunningJarName() {
		
		String className = this.getClass().getName().replace('.', '/');
		String classJar = this.getClass().getResource("/" + className + ".class").toString();
		
		if (classJar.startsWith("jar:")) {
			String vals[] = classJar.split("/");
			for (String val : vals) {
				if (val.contains("!")) {
					return val.substring(0, val.length() - 1);
				}
			}
		}
		
		return null;
	}// END: getRunningJarName

	public static void main(String[] args) {

		String runningJarName = new Main().getRunningJarName();
		if (runningJarName != null) {
			System.out.println("Running from " + runningJarName);
		} else {
			System.out.println("Not running from a jar");
		}

	}// END: main

}// END: Main
