/********************************************************************************
 * Copyright (c) 2020 Equo
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Guillermo Zunino, Equo - initial implementation
 ********************************************************************************/
 /* automatically generated by rust-bindgen */

#![allow(dead_code)]
#![allow(non_snake_case)]
#![allow(non_camel_case_types)]
#![allow(non_upper_case_globals)]
use cef::cef_string_t;


///
/// Structure representing CefExecuteProcess arguments.
///
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_main_args_t {
    pub argc: ::std::os::raw::c_int,
    pub argv: *mut *mut ::std::os::raw::c_char,
}
///
/// Class representing window information.
///
#[repr(C)]
pub struct _cef_window_info_t {
    pub window_name: cef_string_t,
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub width: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
    ///
    /// Set to true (1) to create the view initially hidden.
    ///
    pub hidden: ::std::os::raw::c_int,
    ///
    /// NSView pointer for the parent view.
    ///
    pub parent_view: *mut ::std::os::raw::c_void,
    ///
    /// Set to true (1) to create the browser using windowless (off-screen)
    /// rendering. No view will be created for the browser and all rendering will
    /// occur via the CefRenderHandler interface. The |parent_view| value will be
    /// used to identify monitor info and to act as the parent view for dialogs,
    /// context menus, etc. If |parent_view| is not provided then the main screen
    /// monitor will be used and some functionality that requires a parent view
    /// may not function correctly. In order to create windowless browsers the
    /// CefSettings.windowless_rendering_enabled value must be set to true.
    /// Transparent painting is enabled by default but can be disabled by setting
    /// CefBrowserSettings.background_color to an opaque value.
    ///
    pub windowless_rendering_enabled: ::std::os::raw::c_int,
    ///
    /// NSView pointer for the new browser view. Only used with windowed rendering.
    ///
    pub view: *mut ::std::os::raw::c_void,
}
