// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pcommon

import (
	"go.opentelemetry.io/collector/pdata/internal"
)

// ByteSlice represents a []byte slice.
// The instance of ByteSlice can be assigned to multiple objects since it's immutable.
//
// Must use NewByteSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ByteSlice internal.ByteSlice

func (ms ByteSlice) getOrig() *[]byte {
	return internal.GetOrigByteSlice(internal.ByteSlice(ms))
}

func (ms ByteSlice) getState() *internal.State {
	return internal.GetByteSliceState(internal.ByteSlice(ms))
}

// NewByteSlice creates a new empty ByteSlice.
func NewByteSlice() ByteSlice {
	orig := []byte(nil)
	state := internal.StateMutable
	return ByteSlice(internal.NewByteSlice(&orig, &state))
}

// AsRaw returns a copy of the []byte slice.
func (ms ByteSlice) AsRaw() []byte {
	return copyByteSlice(nil, *ms.getOrig())
}

// FromRaw copies raw []byte into the slice ByteSlice.
func (ms ByteSlice) FromRaw(val []byte) {
	ms.getState().AssertMutable()
	*ms.getOrig() = copyByteSlice(*ms.getOrig(), val)
}

// Len returns length of the []byte slice value.
// Equivalent of len(byteSlice).
func (ms ByteSlice) Len() int {
	return len(*ms.getOrig())
}

// At returns an item from particular index.
// Equivalent of byteSlice[i].
func (ms ByteSlice) At(i int) byte {
	return (*ms.getOrig())[i]
}

// SetAt sets byte item at particular index.
// Equivalent of byteSlice[i] = val
func (ms ByteSlice) SetAt(i int, val byte) {
	ms.getState().AssertMutable()
	(*ms.getOrig())[i] = val
}

// EnsureCapacity ensures ByteSlice has at least the specified capacity.
//  1. If the newCap <= cap, then is no change in capacity.
//  2. If the newCap > cap, then the slice capacity will be expanded to the provided value which will be equivalent of:
//     buf := make([]byte, len(byteSlice), newCap)
//     copy(buf, byteSlice)
//     byteSlice = buf
func (ms ByteSlice) EnsureCapacity(newCap int) {
	ms.getState().AssertMutable()
	oldCap := cap(*ms.getOrig())
	if newCap <= oldCap {
		return
	}

	newOrig := make([]byte, len(*ms.getOrig()), newCap)
	copy(newOrig, *ms.getOrig())
	*ms.getOrig() = newOrig
}

// Append appends extra elements to ByteSlice.
// Equivalent of byteSlice = append(byteSlice, elms...)
func (ms ByteSlice) Append(elms ...byte) {
	ms.getState().AssertMutable()
	*ms.getOrig() = append(*ms.getOrig(), elms...)
}

// MoveTo moves all elements from the current slice overriding the destination and
// resetting the current instance to its zero value.
func (ms ByteSlice) MoveTo(dest ByteSlice) {
	ms.getState().AssertMutable()
	dest.getState().AssertMutable()
	*dest.getOrig() = *ms.getOrig()
	*ms.getOrig() = nil
}

// CopyTo copies all elements from the current slice overriding the destination.
func (ms ByteSlice) CopyTo(dest ByteSlice) {
	dest.getState().AssertMutable()
	*dest.getOrig() = copyByteSlice(*dest.getOrig(), *ms.getOrig())
}

func copyByteSlice(dst, src []byte) []byte {
	dst = dst[:0]
	return append(dst, src...)
}
