/* packet-bacapp.h
 * by fkraemer, SAUTER
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#ifndef __PACKET_BACAPP_H__
#define __PACKET_BACAPP_H__

#define BACINFO_SERVICE         0
#define BACINFO_INVOKEID        1
#define BACINFO_INSTANCEID      2
#define BACINFO_OBJECTID        4


/* Used for BACnet statistics */
typedef struct _bacapp_info_value_t {
    const gchar     *service_type;
    const gchar     *invoke_id;
    const gchar     *instance_ident;
    const gchar     *object_ident;
} bacapp_info_value_t;

#endif /* __PACKET_BACNET_H__ */

/*
 * Editor modelines  -  http://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 4
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=4 tabstop=8 expandtab:
 * :indentSize=4:tabSize=8:noTabs=true:
 */
