/*  Zutils - Utilities dealing with compressed files
    Copyright (C) 2009-2019 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

int readblock( const int fd, uint8_t * const buf, const int size );
int writeblock( const int fd, const uint8_t * const buf, const int size );
bool feed_data( const std::string & filename, const int infd, const int outfd,
                const uint8_t * magic_data, const int magic_size );

struct Children
  {
  const char * compressor_name;
  pid_t pid[2];				// data feeder, compressor
  };
bool good_status( const Children & children, const bool finished );
bool set_data_feeder( const std::string & filename, int * const infdp,
                      Children & children, int format_index );

// Returns format index or -1 if uncompressed
//
int test_format( const int infd, const uint8_t ** const magic_datap,
                 int * const magic_sizep );
